<?php
/* SVN FILE: $Id: logout.php 198 2008-04-29 07:24:33Z bb_yujiro $ */
/**
 * ログイン
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 198 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-29 16:24:33 +0900 (火, 29 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * WebApplicationクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 198 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-29 16:24:33 +0900 (火, 29 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller
{
    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        /* ログイン後のデフォルトジャンプ先 */
        $jumps = array(
            STATUS_ADMIN=>  HTTP_ACTION.'private/',
            STATUS_MEMBER=> HTTP_ACTION.'private/home/',
            STATUS_GUEST=>  HTTP_ACTION.'public/login/entrance/',
        );

        RKT_Auth::exec()->logOut();

        $this->objvew->setTemplate('generalbar_tpl', 'common/menuBar/guest.tpl');
        $this->objvew->setTemplate('groupbar_tpl',   'common/menuBar/public.tpl');

        $account = array(
            'id'       => 0,
            'name'     => '',
            'status'   => STATUS_GUEST,
            'ref_theme'=> DEFAULT_THEME,
        );
        $this->objvew->baseAssign('account', $account);
        $this->objvew->baseAssign('member',  $account);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
    }
} // class Controller
?>
