<?php
/* SVN FILE: $Id: entrance.php 184 2008-04-26 17:24:42Z bb_yujiro $ */
/**
 * ログイン
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 184 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-27 02:24:42 +0900 (日, 27 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * WebApplicationクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 184 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-27 02:24:42 +0900 (日, 27 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller
{
    /**
     * チェックフラグ
     * @var string
     */
    protected $mismatch = null;

    /**
     * メールアドレス
     * @var string
     */
    protected $email = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        /* ログイン後のデフォルトジャンプ先 */
        $jumps = array(
            STATUS_ADMIN=>  HTTP_ACTION.'private/',
            STATUS_MEMBER=> HTTP_ACTION.'private/home/',
            STATUS_GUEST=>  HTTP_ACTION.'public/login/entrance/',
        );

        RKT_Auth::exec()->logOut();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'mismatch'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }
} // class Controller
?>
