<?php
/* SVN FILE: $Id: invite.php 385 2008-05-15 02:43:17Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktAuth/CAPTCHA.php';

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_invite',
        ),
        'view'=> array(
        ),            
    );

    /**
     * fri_invite モデルオブジェクト
     * @var object 
     */
    public $fri_invite = null;

    /**
     * メールアドレス
     * @var string 
     */
    protected $email = null;

    /**
     * 確認用
     * @var string 
     */
    protected $verification = null;

    /**
     * 認証キー
     * @var string 
     */
    protected $phrase = null;

    /**
     * 選択済み
     * @var array
     */
    protected $selected = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $hashed_email = RKT_Crypt::getHashed($this->email);
        $condition = array(
            'ref_account'=>  INVITE_FROM_USER,
            'hashed_email'=> $hashed_email
        );
        $invite = RKT_DB::getRow('fri_invite', $condition);
        if (!empty($invite)){
            $this->fri_invite->setCurId($invite['id']);
        }
        $this->fri_invite->setValue('ref_account', INVITE_FROM_USER);
        $this->fri_invite->setValue('ref_friend', 0);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $objauth = new Auth_CAPTCHA();
        $phrase  = $objauth->getPhrase();
        $option  = $objauth->getOption();

        $this->objvew->assign('phrase', $phrase);
        $this->objvew->assign('option', $option);

        if ($this->checked_nonce){
            $human   = Auth_CAPTCHA::getAuth($this->phrase, $this->selected);
            $matched = $this->_checkEmail();

            if ($human && $matched){
                if (!$this->objrqt->getValidate()){
                    $this->objvew->assign('alert', $this->objrqt->getAlerts());
                } else {
                    $this->fri_invite->setValue('email', $this->email);
                    $this->fri_invite->manip();
                    $this->objvew->assign('sent', true);
                } // if (!$this->objrqt->getValidate())
            } else {
                $this->objvew->assign('bad_select', true);            
            }
        } // if ($this->checked_nonce)
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'verification'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'phrase'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false
            ),
            'selected'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false
            ),
        );
    }

    /**
     * メールアドレスのチェック
     *
     * @access private
     * @return void
     **/
    private function _checkEmail()
    {
        if ($this->email !== $this->verification){
            $this->objvew->assign('unmatched', true);
            return false;
        }

        $hashed_email = RKT_Crypt::getHashed($this->email);
        $condition = array(
            'hashed_email'=> $hashed_email
        );
        $account = RKT_DB::getRow('act_account', $condition);
        
        if (!empty($account['id'])){
            $this->objvew->assign('ismember', true);
            return false;
        }

        return true;
    }
} // class Controller
?>
