<?php
/* SVN FILE: $Id: view.php 494 2008-05-24 11:45:29Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 494 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:45:29 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * WebApplicationクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 494 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:45:29 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller
{
    /**
     * 記事ID
     * @var integer 
     */
    protected $param = null;

    /**
     * 記事内容
     * @var array
     */
    private $_article = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        if ($this->account['status'] != STATUS_GUEST){
            $this->objvew->setTemplate('sidebar_tpl', 'common/menu/profile.tpl');
        }

        $visibility_icon = array(
            VISIBILITY_PUBLIC=>    'world.gif',
            VISIBILITY_PROTECTED=> 'user.gif',
            VISIBILITY_PRIVATE=>   'group_key.gif',
        );
        $this->objvew->baseAssign('visibility_icon', $visibility_icon);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setArticle();

        $tplfiles = array(
            CONTENT_STATIC=>  'static.tpl',
            CONTENT_ARTICLE=> 'view.tpl',
        );
        $tplfile = empty($tplfiles[$this->_article['status']])?'common'.DS.'error'.DS.'notfound.tpl'
                            :'public'.DS.'content'.DS.$tplfiles[$this->_article['status']];
        $this->objvew->setContentFile($tplfile);
        $this->objvew->assign('article', $this->_article);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'param'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 記事の設定
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _setArticle()
    {
        $page2id = array(
            'about'=>   2,
            'privacy'=> 3,
            'terms'=>   4,
        );
        $ref_article = 1;

        if (is_numeric($this->param)){
            $ref_article = $this->param;
        } else {
            $ref_article = empty($page2id[$this->param])? 1:$page2id[$this->param];
        }
        $this->_article = RKT_DB::getRow('atc_article', $ref_article);
    }
} // class Controller
?>
