<?php
/* SVN FILE: $Id: public.php 412 2008-05-18 07:46:01Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Public_Controller extends RKT_Controller
{
    /**
     * コントローラの読み込み
     *
     * @access public
     * @return object
     **/
    public function &getController($group, $module, $page)
    {
        $controller = array (
            'content'=>     array(      // コンテンツ記事
                'cover'=>       true,
                'contact'=>     true,
                'view'=>        true,
            ),
            'json'=>        array(      // データ出力
                'city'=>        true,
                'feed'=>        true,
            ),
            'login'=>       array(      // ログイン
                'entrance'=>    true,
                'exit'=>        true,
                'login'=>       true,
                'logout'=>      true,
                'reissue'=>     true,
            ),
            'plugin'=>      array(      // プラグイン
                'view'=>        true,
            ),
            'join'=>        array(      // 会員登録
                'account'=>     true,
                'invite'=>      true,
            ),
            'review'=>   array(         // レビュー
                'search'=>      true,
                'trackback'=>   true,
                'view'=>        true,
            ),
        );

        if (empty($controller[$module])){
            $module = 'content';
            $page   = 'cover';
        }
        if (empty($controller[$module][$page])){
            $module = 'content';
            $page   = 'cover';
        }

        $include = $group.DS.$module.DS.$page.'.php';
        include CONTROLLER_DIR.$include;
        
        $objController = new Controller($group.DS.$module.DS.$page.'.tpl');
        return $objController;
    }

    /**
     * グループ毎の初期化
     *
     * @access protected
     * @return void
     **/
    protected function initGrouping()
    {
        $this->account = RKT_account::exec()->getAccount();

        /* 会員判定 */
        if ($this->account['status'] == STATUS_GUEST){
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/public.tpl');
        } else {
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
            $this->objvew->addCss('css/private.css');
        }
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/login.tpl');

        
        $this->visible = VISIBILITY_HIDDEN;
        $this->visible |= VISIBILITY_PUBLIC;
        $this->visible |= VISIBILITY_PROTECTED;
        $this->visible |= VISIBILITY_FRIEND;
        $this->visible |= VISIBILITY_PRIVATE;
        
        $this->objvew->baseAssign('account', $this->account);
        $this->objvew->baseAssign('member',  $this->account);
        $this->objvew->baseAssign('visible', $this->visible);

        Theme::Id($this->account['ref_theme']);

        /* アクセスログ */
        RKT_access::exec()->access(RKT_access::TARGET_PUBLIC, 
                        $this->account['id'], $this->account['id']);
    }
} // class Controller
?>
