<?php
/* SVN FILE: $Id: mobile.php 163 2008-04-23 00:35:07Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_mobile',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_mobile モデルオブジェクト
     * @var object 
     */
    public $act_mobile = null;

    /**
     * メールアドレス１
     * @var string 
     */
    protected $email = null;

    /**
     * メールアドレス２
     * @var string 
     */
    protected $verify_email = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->act_mobile->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_email();
        $this->_password();

        $this->_setDeliveries();
        $this->_setMailings();

        unset($_SESSION['verify_email']);
        unset($_SESSION['verification']);
        unset($_SESSION['password']);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> false
            ),
            'verify_email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> false
            ),
        );
    }

    /**
     * メールアドレス
     *
     * @access private
     * @return void
     **/
    private function _email()
    {
        if (empty($this->email)){
            return ;
        }

        if ($this->email != $this->verify_email){
            $this->act_mobile->objrqt->setAlert('unmatched_email');
        } else {
            $_SESSION['email'] = $this->email;
//            $this->act_mobile->setValue('email', $this->email);
        }

        $this->objvew->assign('changed_email', true);
    }

    /**
     * パスワード
     *
     * @access private
     * @return void
     **/
    private function _password()
    {
        if (empty($this->password)){
            return ;
        }

        if ($this->password != $this->verification){
            $this->act_mobile->objrqt->setAlert('unmatched_password');
        } else {
            $_SESSION['hashed_password'] = $this->password;
        }

        $this->objvew->assign('changed_password', true);
    }

    /**
     * メール受け取りの設定
     *
     * @access private
     * @return void
     **/
    private function _setDeliveries()
    {
        $type = array (
            DELIVERY_DAILY => _('Daily'),
            DELIVERY_WEEK=>   _('Twice a week(Mon/Thu)'),
            DELIVERY_REFUSE=> _('Refuse'),
        );
        $this->objvew->assign('deliveries', $type);
    }

    /**
     * メール受け取りの設定
     *
     * @access private
     * @return void
     **/
    private function _setMailings()
    {
        $type = array (
            STATUS_ENABLE => _('To receive mail'),
            STATUS_DISABLE=> _('Do not receive mail'),
        );
        $this->objvew->assign('mailings', $type);
    }
} // class Controller
?>
