<?php
/* SVN FILE: $Id: cancel.php 492 2008-05-24 11:42:41Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 492 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:42:41 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 492 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:42:41 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_cancel',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_cancel モデルオブジェクト
     * @var object 
     */
    public $act_cancel = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->act_cancel->setValue('ref_account', $this->account['id']);

        if ($this->checked_nonce && !empty($_POST['manip'])){
            RKT_Auth::exec()->logOut();

            $this->objvew->setTemplate('generalbar_tpl', 'common/menuBar/guest.tpl');
            $this->objvew->setTemplate('groupbar_tpl',   'common/menuBar/public.tpl');
            $this->objvew->setTemplate('sidebar_tpl', 'common/menu/login.tpl');
        }
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->account['status'] == STATUS_ADMIN){
            throw new RKT_Exception(RKT_Exception::PERMISSION_DENIED);
        }
    }
} // class Controller
?>
