<?php
/* SVN FILE: $Id: rating.php 385 2008-05-15 02:43:17Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'rev_rating',
        ),
        'view'=> array(
        ),            
    );

    /**
     * rev_rating モデルオブジェクト
     * @var object 
     */
    public $rev_rating = null;

    /**
     * アクション
     * @var string 
     */
    protected $action = null;

    /**
     * 商品コード
     * @var string 
     */
    protected $item_code = null;

    /**
     * 商品コード
     * @var string 
     */
    protected $service = null;

    /**
     * 評価
     * @var integer 
     */
    protected $point = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->rev_rating->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
        if (!empty($this->item_code)){
            $this->rev_rating->setValue('item_code',  $this->item_code, RKT_Model::CONDITION);
        }
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->action == 'json'){
            $this->_setJson();
        } else {
            $this->_setHTML();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'item_code'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'service'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'point'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * HTML処理
     *
     * @access private
     * @return void
     **/
    private function _setHTML()
    {
        $this->_setReview();
        $result = false;
        if ($this->checked_nonce){
            $this->rev_rating->setInitValue();
            $this->rev_rating->setValue('point', $this->point);
            $result = $this->rev_rating->manip();
        }
        $this->objvew->assign('complete', $result);

        $goback = $this->getHttpReferer(1);
        $this->objvew->assign('goBack',  $goback);
    }

    /**
     * JSON処理
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');

        $result = false;
        if ($this->checked_nonce){
            $this->rev_rating->setInitValue();
            $this->rev_rating->setValue('point',      $this->point);
            $result = $this->rev_rating->manip();
        }

        $this->objvew->assign('data', json_encode($result));
    }

    /**
     * レビュー用関連記事の設定
     *
     * @access private
     * @return void
     **/
    private function _setReview()
    {
        if (empty($this->item_code)){
            return ;
        }
        $funcs = array(
            'amazon'=> array('Controller', 'getAmazon'),
            'gnavi'=>  array('Controller', 'getGnavi'),
        );
        $func = empty($funcs[$this->service])? $funcs['amazon']:$funcs[$this->service];
        $item = call_user_func($func, $this->item_code);
        
        $this->objvew->assign('item', $item);
    }

    /**
     * Amazon情報
     *
     * @access public
     * @param string $item_code
     * @return array
     */
    public function getAmazon($item_code)
    {
        include LIB_DIR.'PEAR/Services/AmazonECS4.php';
        $amazon = new Services_AmazonECS4(AMAZON_TOKEN, AMAZON_ASSOCIATEID);
        $options = array(
            'ResponseGroup'=> 'Small'
        );
        $result = $amazon->ItemLookup($item_code, $options);
        if (PEAR::isError($result)) {
            return null;
        }
        if (empty($result['Item'][0])){
            return null;
        }
        $row = $result['Item'][0];

        $comment  = empty($row['ItemAttributes']['Author'][0])? '':$row['ItemAttributes']['Author'][0].'<br>';
        $comment .= empty($row['ItemAttributes']['Artist'])? '':$row['ItemAttributes']['Artist'].'<br>';
        $comment .= empty($row['ItemAttributes']['Manufacturer'])? '':$row['ItemAttributes']['Manufacturer'].'<br>';
        $comment .= empty($row['OfferSummary']['LowestNewPrice']['FormattedPrice'])? '':$row['OfferSummary']['LowestNewPrice']['FormattedPrice'].'<br>';

        return array(
            'atService'=> 'Amazon',
            'view_url'=>  $row['DetailPageURL'],
            'title'=>     $row['ItemAttributes']['Title'],
            'comment'=>   $comment,
        );
    }

    /**
     * ぐるなび情報
     *
     * @access public
     * @param string $item_code
     * @return array
     */
    public function getGnavi($item_code)
    {
        include LIB_DIR.'PEAR/Services/Gnavi.php';
        $gnavi = new Services_Gnavi(GNAVI_ACCESS_KEY);
        $options = array(
            'id'=> $item_code
        );
        $gnavi->searchRestaurant($options);
        $result = $gnavi->getResult();
        if (PEAR::isError($result)) {
            return null;
        }
        if (empty($result['rest'])){
            return null;
        }

        return array(
            'atService'=> 'ぐるなび',
            'view_url'=>  $result['rest']['url'],
            'title'=>     $result['rest']['name'],
            'comment'=>   $result['rest']['pr']['pr_short'],
        );
    }

} // class Controller
?>
