<?php
/* SVN FILE: $Id: poll.php 353 2008-05-11 22:57:53Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'sum_poll',
        ),
        'view'=> array(
        ),            
    );

    /**
     * sum_poll モデルオブジェクト
     * @var object 
     */
    public $sum_poll = null;

    /**
     * アンケートID
     * @var integer
     */
    protected $ref_poll = null;

    /**
     * 解答用入力欄
     * @var array
     */
    protected $answers = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->sum_poll->setCurId($this->ref_poll);

        $this->sum_poll->setValue('ref_account', $this->account['id']);
        $this->sum_poll->setValue('answers',     $this->answers);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setRichEditor();
        $this->objvew->addJavas('js/answer.js');
        
        $this->_setAnswer();

        $img = '<img src="'.BASE_URL.'resource/img/icons/%s" width="16" height="16" align="absmiddle" />&nbsp;';
        $visibility = array(
            VISIBILITY_PUBLIC=>    sprintf($img, 'world.gif') . _('Public'),
            VISIBILITY_PROTECTED=> sprintf($img, 'user.gif') . _('Members'),
            VISIBILITY_PRIVATE=>   sprintf($img, 'group_key.gif') . _('Private'),
        );
        $this->objvew->assign('visibility', $visibility);

        $visibility_icon = array(
            VISIBILITY_PUBLIC=>    'world.gif',
            VISIBILITY_PROTECTED=> 'user.gif',
            VISIBILITY_PRIVATE=>   'group_key.gif',
        );
        $this->objvew->baseAssign('visibility_icon', $visibility_icon);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_poll'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'answers'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 解答用入力欄設定
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _setAnswer()
    {
        $arrays = $this->sum_poll->answers;
        $arrays = is_array($arrays)? $arrays:array();
        $this->objvew->assign('answers', $arrays);
    }
} // class Controller
?>
