<?php
/* SVN FILE: $Id: blog.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'blg_entry',
        ),
        'view'=> array(
        ),            
    );

    /**
     * blg_entry モデルオブジェクト
     * @var object 
     */
    public $blg_entry = null;

    /**
     * BlogID
     * @var integer
     */
    protected $ref_entry = null;

    /**
     * コミュニティ記事ID
     * @var integer
     */
    protected $ref_article = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/blog.tpl');

        $this->blg_entry->setCurId($this->id);

        $this->blg_entry->setValue('ref_account', $this->account['id']);
        $this->blg_entry->setValue('format',      FORMAT_HTML);
        $this->blg_entry->setValue('link',        '');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_FRIEND=>    _('Friends'),
            VISIBILITY_HIDDEN=>    _('Just me'),
        );
        $this->objvew->assign('visibility', $visibility);

        $this->objvew->assign('related', '');
        $this->objvew->assign('tb_url',  '');
        
        $this->_setRelated();
        $this->_setArticle();
        $this->_setContent();
        $this->_setReview();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'ref_entry'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'ref_article'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'ref_content'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'service'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'item_code'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 関連記事の設定
     *
     * @access private
     * @return void
     **/
    private function _setRelated()
    {
        if (empty($this->ref_entry)){
            return ;
        }

        $row = RKT_DB::getRow('blg_entry', $this->ref_entry);
        $related  = '[<a href="'.HTTP_ACTION.'member/blog/view/'.$this->ref_entry.'/">';
        $related .= $row['subject'];
        $related .= '</a>]';

        $this->objvew->assign('related', $related);
        $this->objvew->assign('tb_url',  HTTP_ACTION.'member/blog/trackback/'.$this->ref_entry.'/');
    }

    /**
     * 関連コミュニティ記事の設定
     *
     * @access private
     * @return void
     **/
    private function _setArticle()
    {
        if (empty($this->ref_article)){
            return ;
        }

        $row = RKT_DB::getRow('com_article', $this->ref_article);
        $related  = '[<a href="'.HTTP_ACTION.'community/article/view/'.$this->ref_article.'/">';
        $related .= $row['article'];
        $related .= '</a>]';

        $this->objvew->assign('related', $related);
        $this->objvew->assign('tb_url',  HTTP_ACTION.'community/article/trackback/'.$this->ref_article.'/');
    }

    /**
     * 関連サイト記事の設定
     *
     * @access private
     * @return void
     **/
    private function _setContent()
    {
        if (empty($this->ref_content)){
            return ;
        }

        $row = RKT_DB::getRow('atc_article', $this->ref_content);
        $related  = '[<a href="'.HTTP_ACTION.'public/content/view/'.$this->ref_content.'/">';
        $related .= $row['subject'];
        $related .= '</a>]';

        $this->objvew->assign('related', $related);
        $this->objvew->assign('tb_url',  HTTP_ACTION.'public/content/trackback/'.$this->ref_content.'/');
    }

    /**
     * レビュー用関連記事の設定
     *
     * @access private
     * @return void
     **/
    private function _setReview()
    {
        if (empty($this->item_code)){
            return ;
        }
        $funcs = array(
            'amazon'=> array('Controller', 'getAmazon'),
            'gnavi'=>  array('Controller', 'getGnavi'),
        );
        $func = empty($funcs[$this->service])? $funcs['amazon']:$funcs[$this->service];
        $item = call_user_func($func, $this->item_code);
        
        $related  = '<table><tbody><tr>';
        $related .= '<td>';
        $related .= '<a href="'.$item['view_url'].'"><img src="'. BASE_URL.'review'.ACTION_STYLE.'/'.$this->service.'/160/'.$this->item_code.'.jpg' .'" /></a><br>';
        $related .= '<a href="'.$item['view_url'].'">'.sprintf(_('More at %s'), $item['atService']) .'</a>';
        $related .= '</td>';
        $related .= '<td>';
        $related .= '<strong>'.$item['title'].'</strong><br>';
        $related .= $item['comment'].'<br><br>';
        $related .= _('Rating:').'<a href="'.HTTP_ACTION.'public/review/view/'.$this->service.'/'.$this->item_code.'/">';
        $related .= '<img src="'. BASE_URL.'review'.ACTION_STYLE.'/rating/'.$this->account['id'].'/'.$this->item_code.'.gif' .'" /></a><br>';
        $related .= '</td>';
        $related .= '</tr></tbody></table>';

        $this->objvew->assign('related', $related);
        $this->objvew->assign('tb_url',  HTTP_ACTION.'public/review/trackback/'.$this->item_code.'/');
    }

    /**
     * Amazon情報
     *
     * @access public
     * @param string $item_code
     * @return array
     */
    public function getAmazon($item_code)
    {
        include LIB_DIR.'PEAR/Services/AmazonECS4.php';
        $amazon = new Services_AmazonECS4(AMAZON_TOKEN, AMAZON_ASSOCIATEID);
        $options = array(
            'ResponseGroup'=> 'Small'
        );
        $result = $amazon->ItemLookup($item_code, $options);
        if (PEAR::isError($result)) {
            return null;
        }
        if (empty($result['Item'][0])){
            return null;
        }
        $row = $result['Item'][0];

        $comment  = empty($row['ItemAttributes']['Author'][0])? '':$row['ItemAttributes']['Author'][0].'<br>';
        $comment .= empty($row['ItemAttributes']['Artist'])? '':$row['ItemAttributes']['Artist'].'<br>';
        $comment .= empty($row['ItemAttributes']['Manufacturer'])? '':$row['ItemAttributes']['Manufacturer'].'<br>';
        $comment .= empty($row['OfferSummary']['LowestNewPrice']['FormattedPrice'])? '':$row['OfferSummary']['LowestNewPrice']['FormattedPrice'].'<br>';

        return array(
            'atService'=> 'Amazon',
            'view_url'=>  $row['DetailPageURL'],
            'title'=>     $row['ItemAttributes']['Title'],
            'comment'=>   $comment,
        );
    }

    /**
     * ぐるなび情報
     *
     * @access public
     * @param string $item_code
     * @return array
     */
    public function getGnavi($item_code)
    {
        include LIB_DIR.'PEAR/Services/Gnavi.php';
        $gnavi = new Services_Gnavi(GNAVI_ACCESS_KEY);
        $options = array(
            'id'=> $item_code
        );
        $gnavi->searchRestaurant($options);
        $result = $gnavi->getResult();
        if (PEAR::isError($result)) {
            return null;
        }
        if (empty($result['rest'])){
            return null;
        }

        return array(
            'atService'=> 'ぐるなび',
            'view_url'=>  $result['rest']['url'],
            'title'=>     $result['rest']['name'],
            'comment'=>   $result['rest']['pr']['pr_short'],
        );
    }
} // class Controller
?>
