<?php
/* SVN FILE: $Id: request.php 163 2008-04-23 00:35:07Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_names',
        ),
        'view'=> array(
        ),            
    );

    /**
     * com_names モデルオブジェクト
     * @var object 
     */
    public $com_names = null;

    /**
     * コミュニティ名簿ID
     * @var integer
     */
    protected $ref_names = null;

    /**
     * ステータス
     * @var integer
     */
    protected $status = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_names->setCurId($this->ref_names);
        $this->com_names->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $accepted = false;
        $denied   = false;
        $accept   = false;
        $deny     = false;
        if ($this->checked_nonce){
            if (!empty($_POST['accept'])){
                $this->com_names->setValue('status', PERMISSION_LEADER);
                $this->com_names->setUpdate();
                $this->com_names->manip();
                $accepted = true;
            } elseif (!empty($_POST['deny'])){
                $this->com_names->setValue('status', PERMISSION_MEMBER);
                $this->com_names->setUpdate();
                $this->com_names->manip();
                $denied = true;
            }
        } else {
            if ($this->status == PERMISSION_LEADER){
                $accept = true;
            } else {
                $deny = true;
            }
        }

        $this->objvew->assign('accepted', $accepted);
        $this->objvew->assign('denied',   $denied);
        $this->objvew->assign('accept',   $accept);
        $this->objvew->assign('deny',     $deny);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_names'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }
} // class Controller
?>
