<?php
/* SVN FILE: $Id: photo.php 475 2008-05-22 09:39:04Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 475 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:39:04 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 475 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:39:04 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_photo',
        ),
        'view'=> array(
            'act_attach',
        ),            
    );

    /**
     * act_photo モデルオブジェクト
     * @var object 
     */
    public $act_photo = null;

    /**
     * v_act_attach モデルオブジェクト
     * @var object 
     */
    public $v_act_attach = null;

    /**
     * アルバムID
     * @var integer 
     */
    protected $ref_album = null;

    /**
     * ID
     * @var integer 
     */
    protected $selected = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/album.tpl');

        $this->act_photo->setCurId($this->id);
        $this->act_photo->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);

        if ($this->ref_album != ''){
            $this->v_act_attach->setValue('ref_album', $this->ref_album);
        }
        $this->v_act_attach->setValue('ref_account', $this->account['id']);
        $this->v_act_attach->setLimit(LIMIT_TILE);
        $this->v_act_attach->setOrder('modified DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $row = RKT_DB::getRow('act_photo', $condition, 'count(*) as ct');
        $maxrow = empty($row['ct'])? 0:$row['ct'];

        if ($this->checked_nonce){
            if (!empty($_POST['manip']) && $maxrow <= 3){
                $this->act_photo->catchFile('photo');
                $this->act_photo->setValue('status', STATUS_PHOTO_SUB);
                $this->act_photo->manip();
                $maxrow++;
            }

            if (!empty($_POST['select']) && $maxrow <= 3){
                $this->_selectPhoto();
                $maxrow++;
            }

            if ($this->action == 'main'){
                $this->act_photo->setUpdate();
                $this->act_photo->setValue('status', STATUS_PHOTO_MAIN);
                $this->act_photo->manip();
            }

            if ($this->action == 'delete'){
                $this->act_photo->setDelete();
                $this->act_photo->manip();
                $maxrow--;
            }
        } // if ($this->checked_nonce)

        $photos = RKT_DB::getList('act_photo', $condition);
        $this->objvew->assign('photos', $photos);

        $albums = RKT_DB::getList('act_album', $condition);
        $this->objvew->assign('albums', $albums);

        $this->objvew->assign('maxrow', $maxrow);        
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'ref_album'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'selected'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 画像の選択
     *
     * @access public
     * @return void
     **/
    protected function _selectPhoto()
    {
        $row = RKT_DB::getRow('act_attach', $this->selected);

        $this->act_photo->setValue('ref_account', $this->account['id']);
        $this->act_photo->setValue('status',      STATUS_PHOTO_SUB);

        $this->act_photo->selectedPhoto($row['filename']);
        $this->act_photo->manip();
    }
} // class Controller
?>
