<?php
/* SVN FILE: $Id: browse.php 177 2008-04-24 11:32:06Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 177 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-24 20:32:06 +0900 (木, 24 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 177 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-24 20:32:06 +0900 (木, 24 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_message',
        ),
        'view'=> array(
        ),            
    );

    /**
     * fri_message モデルオブジェクト
     * @var object 
     */
    public $fri_message = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/message.tpl');

        $this->fri_message->setCurId($this->id);
        $this->fri_message->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->assign('id',     $this->id);
        $this->objvew->assign('status', $this->fri_message->status);

        $munu_class = array(
            MESSAGE_INBOX=> '',
            MESSAGE_SENT=>  '',
            MESSAGE_DRAFT=> '',
            MESSAGE_TRASH=> '',
        );
        $munu_class[$this->fri_message->status] = ' class="column"';
        $this->objvew->assign('menu_class', $munu_class);

        $targets = array(
            MESSAGE_INBOX=> 'ref_from',
            MESSAGE_SENT=>  'ref_to',
            MESSAGE_DRAFT=> 'ref_to',
            MESSAGE_TRASH=> 'ref_from',
        );
        $this->objvew->assign('target', $targets[$this->fri_message->status]);

        $statuses = array(
            MESSAGE_INBOX=> _('Inbox'),
            MESSAGE_SENT=>  _('Sent'),
            MESSAGE_DRAFT=> _('Draft'),
            MESSAGE_TRASH=> _('Trash'),
        );
        $this->objvew->assign('statuses', $statuses);

        $this->fri_message->messageFlag();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
