<?php
/* SVN FILE: $Id: living.php 522 2008-05-30 16:19:57Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 522 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:19:57 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 522 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:19:57 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setAnnouncement();

        $this->_setCatchFriend();
        $this->_setChangeLeader();
        $this->_setCommunityEntry();
        $this->_setNewMessage();
        $this->_setNewComment();
    }

    /**
     * サイトからのアナウンス設定
     *
     * @access private
     * @return void
     */
    private function _setAnnouncement()
    {
        $condition = array(
            'status'=> array('!=', CONTENT_STATIC),
        );
        $list = RKT_DB::getList('atc_article', $condition, 
                    '*', 'regist_date DESC', LIMIT_ANNOUNCEMENT);
        $this->objvew->assign('announcement', $list);
    }

    /**
     * 友達登録の設定
     *
     * @access private
     * @return void
     */
    private function _setCatchFriend()
    {
        $condition = array(
            'ref_account'=> $this->account['id'],
            'status'=>      STATUS_FRIEND_THROW,
        );
        $result = RKT_DB::getRow('fri_friends', $condition, 'count(id) as ct');

        $this->objvew->assign('catch_friend', $result['ct']);
    }

    /**
     * 管理人交代の設定
     *
     * @access private
     * @return void
     */
    private function _setChangeLeader()
    {
        $condition = array(
            'ref_account'=> $this->account['id'],
            'status'=>      PERMISSION_CHANGE,
        );
        $result = RKT_DB::getRow('com_names', $condition, 'count(id) as ct');

        $this->objvew->assign('change_leader', $result['ct']);
    }

    /**
     * コミュニティ参加の設定
     *
     * @access private
     * @return void
     */
    private function _setCommunityEntry()
    {
        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $communities = RKT_DB::getList('com_community', $condition, 'id');
        if (empty ($communities)){
            return ;
        }
        
        $count = 0;
        foreach ($communities as $community){
            $condition = array(
                'ref_account'=> $this->account['id'],
                'status'=>      PERMISSION_REQUEST,
            );
            $result = RKT_DB::getRow('com_names', $condition, 'count(id) as ct');
            $count += $result['ct'];
        }

        $this->objvew->assign('community_entry', $count);
        $this->objvew->assign('ref_community',   $communities[0]['id']);
    }

    /**
     * 未読のメッセージ設定
     *
     * @access private
     * @return void
     */
    private function _setNewMessage()
    {
        $condition = array(
            'ref_account'=> $this->account['id'],
            'status'=>      MESSAGE_INBOX,
            'flag'=>        FLAG_UNREAD,
        );
        $result = RKT_DB::getRow('fri_message', $condition, 'count(id) as ct');

        $this->objvew->assign('new_message', $result['ct']);
    }

    /**
     * 未読のブログコメント設定
     *
     * @access private
     * @return void
     */
    private function _setNewComment()
    {
        $condition = array(
            'ref_account'=> $this->account['id'],
            'flag'=>        FLAG_UNREAD,
        );
        $result = RKT_DB::getRow('blg_comment', $condition, 'count(id) as ct');

        $this->objvew->assign('new_comment', $result['ct']);

        $condition = array(
            'ref_account'=> $this->account['id'],
            'flag'=>        FLAG_UNREAD,
        );
        $result = RKT_DB::getRow('blg_comment', $condition, 'ref_entry');
        $this->objvew->assign('ref_entry', $result['ref_entry']);
    }
} // class Controller
?>
