<?php
/* SVN FILE: $Id: invite.php 385 2008-05-15 02:43:17Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_invite',
        ),
        'view'=> array(
        ),            
    );

    /**
     * fri_invite モデルオブジェクト
     * @var object 
     */
    public $fri_invite = null;

    /**
     * 招待状
     * @var array
     */
    protected $invitations = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->fri_invite->setValue('ref_account', $this->account['id']);
        $this->fri_invite->setValue('ref_friend', 0);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $hashed_email = RKT_Crypt::getHashed($this->fri_invite->email);
        $condition = array(
            'ref_account'=>  $this->account['id'],
            'hashed_email'=> $hashed_email
        );
        $invite = RKT_DB::getRow('fri_invite', $condition);
        if (!empty($invite)){
            $this->fri_invite->setCurId($invite['id']);
        }
        
        $this->_checkRegistered();
        $this->_deleteInvites();
        $this->_setInvites();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'invitations'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 登録済みユーザーか？
     *
     * @access private
     * @return void
     **/
    private function _checkRegistered()
    {
        $condition = array(
            'hashed_email'=> $hashed_email
        );
        $account = RKT_DB::getRow('act_account', $condition);
        if (!empty($account)){
            $this->fri_invite->objrqt->setAlert('registered');
        }
    }

    /**
     * 招待したメールの削除
     *
     * @access private
     * @return void
     **/
    private function _deleteInvites()
    {
        if (empty($this->invitations)){
            return ;
        }

        $this->fri_invite->setDelete();
        
        foreach ($this->invitations as $id){
            $this->fri_invite->setCurId($id);
            $this->fri_invite->manip();
        }
    }

    /**
     * 招待したメールアドレス一覧
     *
     * @access private
     * @return void
     **/
    private function _setInvites()
    {
        $condition = array(
            'ref_account'=> $this->account['id'],
            'ref_friend'=>  0,
        );
        $invites = RKT_DB::getList('fri_invite', $condition, '*', 'modified');
        $this->objvew->assign('invites', $invites);
    }

} // class Controller
?>
