<?php
/* SVN FILE: $Id: attach.php 443 2008-05-20 08:53:37Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 443 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:37 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 443 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:37 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'act_attach',
        ),            
    );

    /**
     * v_act_attach モデルオブジェクト
     * @var object 
     */
    public $v_act_attach = null;

    /**
     * アルバムID
     * @var integer 
     */
    protected $ref_album = null;

    /**
     * 選択ファイル
     * @var string 
     */
    protected $selected = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/album.tpl');

        if ($this->ref_album != ''){
            $this->v_act_attach->setValue('ref_album', $this->ref_album);
        }
        $this->v_act_attach->setValue('ref_account', $this->account['id']);
        $this->v_act_attach->setLimit(LIMIT_TILE);
        $this->v_act_attach->setOrder('modified DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_appendBody();
        $this->_setAlbum();

        $goback = $this->getHttpReferer(0);
        $this->objvew->assign('goBack',  $goback);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_album'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'selected'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * アルバムリストの設定
     *
     * @access private
     * @return void
     **/
    private function _setAlbum()
    {
        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $result = RKT_DB::getList('act_album', $condition);

        $album  = array();
        $albums = array();
        foreach ($result as $row){
            $albums[$row['id']] = $row;
        }
        if (!empty($albums[$this->ref_album])){
            $album = $albums[$this->ref_album];
        }

        $this->objvew->assign('album',  $album);
        $this->objvew->assign('albums', $albums);
    }

    /**
     * 添付ファイル
     *
     * @access private
     * @return void
     **/
    private function _appendBody()
    {
        if (empty($_POST['append'])){
            return ;
        }
        if (empty($this->selected)){
            return ;
        }

        if (array_key_exists('body', $_SESSION)){
            $key = 'body';
        } elseif (array_key_exists('comment', $_SESSION)) {
            $key = 'comment';
        } else {
            return ;
        }

        $body = '';
        foreach ($this->selected as $id){
            $condition = array(
                'id'=>          $id,
                'ref_account'=> $this->account['id']
            );
            $result = RKT_DB::getRow('act_attach', $condition);

            $pos = strpos($result['mime_type'], 'image');
            if (false === $pos){
                $body .= '<a href="'.BASE_URL.$result['origin'].'">'.
                         '<img src="'.BASE_URL.$result['v_small'].'">'.
                         '</a>'."\r\n";
            } else {
                $body .= '<a href="'.BASE_URL.$result['filename'].'">'.
                         '<img src="'.BASE_URL.$result['thumbnail'].'">'.
                         '</a>'."\r\n";
            }
        }

        $_SESSION[$key] .= $body;
        $this->objvew->assign('appended',  true);        
    }
} // class Controller
?>
