<?php
/* SVN FILE: $Id: private.php 353 2008-05-11 22:57:53Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Private_Controller extends RKT_Controller
{
    /**
     * アカウント情報
     * @var array
     */
    protected $account = null;

    /**
     * 各種ID
     * @var integer
     */
    protected $id = null;

    /**
     * アクション
     * @var string
     */
    protected $action = null;

    /**
     * 可視範囲
     * @var integer
     */
    protected $visible = null;

    /**
     * コントローラの読み込み
     *
     * @access public
     * @return object
     **/
    public function &getController($group, $module, $page)
    {
        $controller = array (
            'attach'=>      array(      // 添付ファイル
                'album'=>       true,
                'attach'=>      true,
                'list'=>        true,
                'upload'=>      true,
            ),
            'home'=>        array(      // Myホーム
                'living'=>      true,
                'invite'=>      true,
            ),
            'message'=>     array(      // メッセージ
                'browse'=>      true,
                'list'=>        true,
                'send'=>        true,
            ),
            'personal'=>    array(      // 各種編集
                'community'=>   true,
                'files'=>       true,
                'friends'=>     true,
                'photo'=>       true,
                'profile'=>     true,
                'request'=>     true,
            ),
            'post'=>       array(       // 投稿
                'blog'=>        true,
                'gadget'=>      true,
                'forum'=>       true,
                'poll'=>        true,
                'rating'=>      true,
                'schedule'=>    true,
                'upload'=>      true,
            ),
            'recent'=>       array(     // 近況
                'blog'=>        true,
                'comment'=>     true,
                'event'=>       true,
                'topic'=>       true,
            ),
            'setting'=>     array(      // 会員情報
                'account'=>     true,
                'autologin'=>   true,
                'blog'=>        true,
                'cancel'=>      true,
                'mobile'=>      true,
                'theme'=>       true,
            ),
            'view'=>     array(      // 各種閲覧
                'favorite'=>    true,
                'footprint'=>   true,
            ),
        );

        if (empty($controller[$module])){
            $module = 'home';
            $page   = 'living';
        }
        if (empty($controller[$module][$page])){
            $module = 'home';
            $page   = 'living';
        }

        $status  = RKT_account::exec()->getStatus();
        if ($status == STATUS_GUEST){
            include CONTROLLER_DIR.'public.php';
            $group  = 'public';
            $module = 'login';
            $page   = 'entrance';
        }

        $include = $group.DS.$module.DS.$page.'.php';
        include CONTROLLER_DIR.$include;

        $objController = new Controller($group.DS.$module.DS.$page.'.tpl');
        return $objController;
    }

    /**
     * グループ毎の初期化
     *
     * @access protected
     * @return void
     **/
    protected function initGrouping()
    {
        $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
        $this->objvew->setTemplate('sidebar_tpl',  'common/menu/profile.tpl');
        $this->objvew->addCss('css/private.css');

        $this->account = RKT_account::exec()->getAccount();

        $this->visible = VISIBILITY_HIDDEN;
        $this->visible |= VISIBILITY_PUBLIC;
        $this->visible |= VISIBILITY_PROTECTED;
        $this->visible |= VISIBILITY_FRIEND;
        $this->visible |= VISIBILITY_PRIVATE;
        
        $this->objvew->baseAssign('account', $this->account);
        $this->objvew->baseAssign('member',  $this->account);
        $this->objvew->baseAssign('visible', $this->visible);

        Theme::Id($this->account['ref_theme']);

        /* アクセスログ */
        RKT_access::exec()->access(RKT_access::TARGET_PRIVATE, 
                        $this->account['id'], $this->account['id']);
    }

    /**
     * パスインフォの読み込み
     *
     * @access private
     * @return void
     **/
    private function _setPathInfo()
    {
        /* パスインフォからIDを取得 */
        $condition = array(
            'type'=>     'number',
            'option'=>   array(),            
            'required'=> false,
            'pic_up'=>   'PathArgs'
        );
        if ($this->objrqt->catchValidate('id', $condition)){
            $this->id  = $this->objrqt->getRequest('id');
        }
        $this->objvew->baseAssign('id', $this->id);
    }
} // class Controller
?>
