<?php
/* SVN FILE: $Id: view.php 385 2008-05-15 02:43:17Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
        ),            
    );

    /**
     * cal_schedule モデルオブジェクト
     * @var object 
     */
    public $v_cal_schedule = null;

    /**
     * 予定(Member_Controllerで取得)
     * @var array 
     */
    protected $schedule = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->setRichEditor();
        $this->objvew->assign('schedule', $this->schedule);

        $condition = array(
            'ref_schedule'=> $this->schedule['id']
        );
        $list = RKT_DB::getList('cal_comment', $condition, '*', 'modified');
        $this->objvew->assign('comments', $list);

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_FRIEND=>    _('Friends'),
            VISIBILITY_HIDDEN=>    _('Just me'),
        );
        $this->objvew->assign('visibility', $visibility);

        $reminders = array(
            STATUS_DISABLE=> _('Do not send a reminder.'),
            STATUS_ENABLE=>  _('Send a reminder.'),
        );
        $this->objvew->assign('reminders', $reminders);

        $reminder_icons = array(
            STATUS_DISABLE=> 'send_cross',
            STATUS_ENABLE=>  'sent',
        );
        $this->objvew->assign('reminder_icons', $reminder_icons);

        $this->_setNext();
        $this->_setPrev();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
    }

    /**
     * 次のスケジュールの設定
     *
     * @access private
     * @return void
     */
    function _setNext()
    {
        $condition = array(
            ':ref_account'=> $this->schedule['ref_account'],
            ':start_date'=>  $this->schedule['start_date'],
            ':visibility'=>  $this->visible,
        );

        $bitflag = RKT_DB::bitFlag('visibility & :visibility');
        $sql = 'SELECT * FROM '.DB_PREFIX.'cal_schedule '.
               'WHERE ref_account = :ref_account AND '.
                    'start_date > :start_date AND '.$bitflag.' '.
               'ORDER BY start_date ASC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute($condition); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->objvew->assign('next', $result);
    }

    /**
     * 前のスケジュールの設定
     *
     * @access private
     * @return void
     */
    function _setPrev()
    {
        $condition = array(
            ':ref_account'=> $this->schedule['ref_account'],
            ':start_date'=>  $this->schedule['start_date'],
            ':visibility'=>  $this->visible,
        );

        $bitflag = RKT_DB::bitFlag('visibility & :visibility');
        $sql = 'SELECT * FROM '.DB_PREFIX.'cal_schedule '.
               'WHERE ref_account = :ref_account AND '.
                    'start_date < :start_date AND '.$bitflag.' '.
               'ORDER BY start_date DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute($condition); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->objvew->assign('prev', $result);
    }
} // class Controller
?>
