<?php
/* SVN FILE: $Id: list.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'sum_poll',
        ),            
    );

    /**
     * sum_poll モデルオブジェクト
     * @var object 
     */
    public $v_sum_poll = null;

    /**
     * サマリーアクション
     * @var string
     */
    protected $summary = null;

    /**
     * サマリーリスト
     * @var array
     */
    private $_list = array();

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->v_sum_poll->setValue('ref_account', $this->member['id']);
        $this->v_sum_poll->setValue('visibility',  $this->visible, '&');
        $this->v_sum_poll->setOrder('regist_date DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setSummary();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'summary'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * Summaryデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setSummary()
    {
        if (empty($this->summary)){
            return ;
        }

        $result = $this->v_sum_poll->getValues();
        foreach ($result as $row){
            /* プロフィール */
            $condition = array(
                'ref_account'=> $row['ref_account']
            );
            $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

            $this->_list[] = array(
                'id'=>          $row['code'],
                'title'=>       $row['poll'],
                'link'=>        HTTP_ACTION.'member/poll/view/'.$row['id'].'/',
                'modified'=>    $row['modified'],
                'date'=>        fDate($row['modified'], _('Y-m-d')),
                'creator'=>     $profile['nickname'],
                'description'=> strip_tags($row['comment']),
            );
        }

        if ($this->summary == 'json'){
            $this->_setJson();
        } else {
            $this->_setXml();
        }
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->objvew->assign('data', json_encode($this->_list));
    }

    /**
     * XMLデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setXml()
    {
        if ($this->summary == 'rss'){
            $this->objvew->setBaseFile('common/summary/rss.tpl');
        } elseif ($this->summary == 'atom') {
            $this->objvew->setBaseFile('common/summary/atom.tpl');
        } elseif ($this->summary == 'rdf') {
            $this->objvew->setBaseFile('common/summary/rdf.tpl');
        } else {
            return ;
        }
        $this->objvew->setMimeType('text/xml');
        $modified = empty($this->_list[0]['modified'])? 'now':$this->_list[0]['modified'];

        /* プロフィール */
        $condition = array(
            'ref_account'=> $this->member['id']
        );
        $profile = RKT_DB::getRow('act_profile', $condition, 'nickname,comment');

        $summary = array(
            'title'=>       sprintf(_("%s's Poll"), $profile['nickname']),
            'link'=>        HTTP_ACTION.'member/poll/list/'.$this->member['id'].'/',
            'modified'=>    $modified,
            'creator'=>     $profile['nickname'],
            'description'=> strip_tags($profile['comment']),
            'list'=>        $this->_list
        );

        $this->objvew->assign('summary', $summary);
    }
} // class Controller
?>
