<?php
/* SVN FILE: $Id: profile.php 524 2008-05-30 16:21:46Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 524 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:21:46 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 524 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:21:46 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_personality',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_personality モデルオブジェクト
     * @var object 
     */
    public $act_personality = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->act_personality->setValue('ref_account', $this->account['id']);

        $this->_setItem();
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $condition = array(
            'ref_account'=> $this->id
        );
        $profile = RKT_DB::getRow('act_profile', $condition);

        /* ユーザーなし */
        if (empty($profile)){
            throw new RKT_Exception(RKT_Exception::NOT_FOUND);
        }

        $this->objvew->assign('profile', $profile);
    }

    /**
     * 追加項目の設定
     *
     * @access private
     * @return void
     */
    private function _setItem()
    {
        $list = $this->act_personality->getPersonality();
        $this->objvew->assign('items', $list);
    }
} // class Controller
?>
