<?php
/* SVN FILE: $Id: community.php 474 2008-05-22 09:38:43Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 474 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:38:43 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 474 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:38:43 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'com_names',
        ),            
    );

    /**
     * v_com_names モデルオブジェクト
     * @var object 
     */
    public $v_com_names = null;

    /**
     * JSON指定
     * @var string 
     */
    protected $json = null;

    /**
     * ステータス
     * @var integer 
     */
    protected $status = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $status = empty($this->status)? PERMISSION_MEMBERS:$this->status;
        if ($this->member['id'] != $this->account['id']){
            $status = PERMISSION_MEMBERS;
        }

        $this->v_com_names->setValue('ref_account', $this->member['id']);
        $this->v_com_names->setValue('status',      $status, '&');
        $this->v_com_names->setValue('visibility',  $this->visible, '&');

        $this->v_com_names->setLimit(LIMIT_TILE);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setCommand();
        $this->_setJson();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'json'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }

    /**
     * コマンドの設定
     *
     * @access private
     * @return void
     **/
    private function _setCommand()
    {
        $command = '';
        if ($this->member['id'] != $this->account['id']){
            $this->objvew->assign('command', $command);
            return ;
        }
        $nonce = RKT_Crypt::getNonce('manipNonce');

        /* 設定する */
        $command .= '&nbsp;<a href="'.HTTP_ACTION.'private/personal/'.
                    'community/%s/"><img src="'.BASE_URL.'resource/img/icons/group_edit.gif"'.
                    ' width="16" height="16" alt="'._('Setting').'" /></a>&nbsp;'.
        /* 退会する */
                    '&nbsp;<a name="%s" href="'.HTTP_ACTION.'community/setting/'.
                    'resign/%s/delete/"><img src="'.BASE_URL.'resource/img/icons/disconnect.gif"'.
                    ' width="16" height="16" alt="'._('Resign').'" /></a>&nbsp;';
        
        if ($this->status == PERMISSION_CHANGE) {
            /* 承諾する */
            $command  = '&nbsp;<a href="'.HTTP_ACTION.'private/personal/'.
                        'request/%s/'.US.'status='.PERMISSION_LEADER.'"><img src="'.BASE_URL.'resource/img/icons/leader_change.gif"'.
                        ' width="16" height="16" alt="'._('Accept').'" /></a>&nbsp;'.
            /* 拒否する */
                        '&nbsp;<a href="'.HTTP_ACTION.'private/personal/'.
                        'request/%s/'.US.'status='.PERMISSION_MEMBER.'"><img src="'.BASE_URL.'resource/img/icons/cross.gif"'.
                        ' width="16" height="16" alt="'._('Deny').'" /></a>&nbsp;';
        }

        $this->objvew->assign('command', $command);
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        if ($this->json != 'json'){
            return ;
        }
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->v_com_names->setLimit(LIMIT_JSON_COMMUNITYS);
        $this->v_com_names->setField('ref_community');
        $friends = $this->v_com_names->getValues();
        
        $list = array();
        foreach ($friends as $row){
            $community = RKT_DB::getRow('com_community', $row['ref_community']);

            $list[] = array(
                'id'=>        $row['ref_community'],
                'name'=>      $community['community'],
                'community'=> $community['community'],
                'src'=>       empty($community['thumbnail'])? NOPHOTO_SMALL:$community['thumbnail'],
                'width'=>     empty($community['t_width'])?   PHOTO_SMALL_SIZE:$community['t_width'],
                'height'=>    empty($community['t_height'])?  PHOTO_SMALL_SIZE:$community['t_height'],
            );
        }

        $this->objvew->assign('data', json_encode($list));
    }

} // class Controller
?>
