<?php
/* SVN FILE: $Id: calendar.php 163 2008-04-23 00:35:07Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_photo モデルオブジェクト
     * @var object 
     */
    public $act_photo = null;

    /**
     * v_act_photo モデルオブジェクト
     * @var object 
     */
    public $v_act_photo = null;

    /**
     * タイムスタンプ
     * @var string
     */
    private $_timestamp = null;

    /**
     * 予定
     * @var array
     */
    private $_schedule = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->_timestamp = empty($this->date)? strtotime(date('Y-m-01')):$this->date;
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setAddSchedule();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'date'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 編集リンクの作成
     *
     * @access public
     * @return void
     **/
    private function _setAddSchedule()
    {
        $now   = strtotime(date('Y-m-01'));
        $start = 1;

        if ($this->_timestamp < $now){
            return ;
        } elseif ($this->_timestamp == $now){
            $start = date('d');
        }
                
        for ($day=$start; $day<=31; $day++){
            $days = strtotime(($day-1).' day', $this->_timestamp);
            $href = HTTP_ACTION.'private/post/schedule/0/'.$days.'/';
            $anc  = '<a href="'.$href.'">';
            $anc .= '<img src="'.BASE_URL.'resource/img/icons/date_edit.gif" width="16" height="16" align="absbottom" />';
            $anc .= '</a>';
            
            $this->_schedule[$day][] = $anc;
        }
        $this->objvew->assign('schedule', $this->_schedule);

    }
} // class Controller
?>
