<?php
/* SVN FILE: $Id: view.php 425 2008-05-19 11:30:51Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 425 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-19 20:30:51 +0900 (月, 19 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 425 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-19 20:30:51 +0900 (月, 19 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'blg_comment',
        ),
        'view'=> array(
        ),
    );

    /**
     * blg_comment モデルオブジェクト
     * @var object 
     */
    public $blg_comment = null;

    /**
     * 記事(Member_Controllerで取得)
     * @var array
     */
    protected $entry = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/blog.tpl');

        $this->blg_comment->setValue('ref_entry',   $this->entry['id']);
        $this->blg_comment->setValue('ref_account', $this->account['id']);
        $this->blg_comment->readComment();
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->visible & $this->entry['visibility'])){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }
        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();
        $this->objvew->assign('entry', $this->entry);
        
        $this->_setComment();
        $this->_setTag();
        $this->_setTrackback();
        
        $this->_setNext();
        $this->_setPrev();
    }

    /**
     * コメントの設定
     *
     * @access private
     * @return void
     */
    private function _setComment()
    {
        $condition = array(
            'ref_entry'=> $this->entry['id']
        );
        $list = RKT_DB::getList('blg_comment', $condition, '*', 'modified');
        $this->objvew->assign('comments', $list);
    }

    /**
     * タグの設定
     *
     * @access private
     * @return void
     */
    private function _setTag()
    {
        if (empty($this->entry['tag'])){
            return ;
        }
        $tags = str_replace('　', ' ', $this->entry['tag']);
        $tags = explode(' ', $tags);

        $this->objvew->assign('tags', $tags);        
    }

    /**
     * トラックバックの設定
     *
     * @access private
     * @return void
     */
    private function _setTrackback()
    {
        $condition = array(
            'ref_entry'=> $this->entry['id']
        );
        $list = RKT_DB::getList('blg_trackback', $condition, '*', 'modified');
        $this->objvew->assign('trackbacks', $list);
    }

    /**
     * 次の日記の設定
     *
     * @access private
     * @return void
     */
    private function _setNext()
    {
        $condition = array(
            ':ref_account'=> $this->entry['ref_account'],
            ':regist_date'=> $this->entry['regist_date'],
            ':visibility'=>  $this->visible,
        );

        $bitflag = RKT_DB::bitFlag('visibility & :visibility');
        $sql = 'SELECT * FROM '.DB_PREFIX.'blg_entry '.
               'WHERE ref_account = :ref_account AND '.
                    'regist_date > :regist_date AND '.$bitflag.' '.
               'ORDER BY regist_date ASC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute($condition); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->objvew->assign('next', $result);
    }

    /**
     * 前の日記の設定
     *
     * @access private
     * @return void
     */
    private function _setPrev()
    {
        $condition = array(
            ':ref_account'=> $this->entry['ref_account'],
            ':regist_date'=> $this->entry['regist_date'],
            ':visibility'=>  $this->visible,
        );

        $bitflag = RKT_DB::bitFlag('visibility & :visibility');
        $sql = 'SELECT * FROM '.DB_PREFIX.'blg_entry '.
               'WHERE ref_account = :ref_account AND '.
                    'regist_date < :regist_date AND '.$bitflag.' '.
               'ORDER BY regist_date DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute($condition); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->objvew->assign('prev', $result);
    }
} // class Controller
?>
