<?php
/* SVN FILE: $Id: comments.php 370 2008-05-13 04:34:21Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 370 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-13 13:34:21 +0900 (火, 13 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 370 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-13 13:34:21 +0900 (火, 13 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'blg_comment',
        ),            
    );

    /**
     * blg_comment モデルオブジェクト
     * @var object 
     */
    public $v_blg_comment = null;

    /**
     * 日記ID
     * @var integer
     */
    protected $ref_entry = null;

    /**
     * サマリーアクション
     * @var string
     */
    protected $summary = null;

    /**
     * サマリーリスト
     * @var array
     */
    private $_list = array();

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/blog.tpl');

        $this->v_blg_comment->setValue('ref_account', $this->member['id']);
        if (!empty($this->ref_entry)){
            $this->v_blg_comment->setValue('ref_entry', $this->ref_entry);
        }

        $this->v_blg_comment->setOrder('regist_date DESC');
        $this->v_blg_comment->setLimit(LIMIT_BLOG);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (empty($this->summary)){
            $this->_setHTML();
        } else {
            $this->_setSummary();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_entry'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'summary'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * HTMLデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setHTML()
    {
        $command = '';
        if (!empty($this->ref_entry)){
            $entry = RKT_DB::getRow('blg_entry', $this->ref_entry);
            $this->objvew->assign('entry', $entry);
            if (!($this->visible & $entry['visibility'])){
                throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
            }
        } else {
            if (!($this->visible & VISIBILITY_FRIEND)){
                throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
            }
            $command  = '<img src="'.BASE_URL.'resource/img/icons/book_open.gif" '.
                        'width="16" height="16" alt="&gt;"/><a href="'.HTTP_ACTION.
                        'member/blog/view/%s/">'._('View Entry').'</a><br>';
        }
        $this->objvew->assign('command', $command);
    }

    /**
     * Summaryデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setSummary()
    {
        if (empty($this->summary)){
            return ;
        }

        $result = $this->v_blg_comment->getValues();
        foreach ($result as $row){
            /* 日記 */
            $entry = RKT_DB::getRow('blg_entry', $row['ref_entry'], 'subject');

            /* プロフィール */
            $condition = array(
                'ref_account'=> $row['ref_author']
            );
            $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

            $this->_list[] = array(
                'title'=>       $entry['subject'],
                'link'=>        HTTP_ACTION.'member/blog/view/'.$row['ref_entry'].'/#Comments',
                'modified'=>    $row['modified'],
                'date'=>        fDate($row['modified'], _('Y-m-d')),
                'creator'=>     $profile['nickname'],
                'description'=> strip_tags($row['comment']),
            );
        }
        
        if ($this->summary == 'json'){
            $this->_setJson();
        } else {
            $this->_setXml();
        }
    }

    /**
     * JSONデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setJson()
    {
        $this->objvew->setBaseFile('common/frame/json.tpl');
        $this->objvew->setMimeType('application/json');
        
        $this->objvew->assign('data', json_encode($this->_list));
    }

    /**
     * XMLデータの設定
     *
     * @access private
     * @return void
     **/
    private function _setXml()
    {
        if ($this->summary == 'rss'){
            $this->objvew->setBaseFile('common/summary/rss.tpl');
        } elseif ($this->summary == 'atom') {
            $this->objvew->setBaseFile('common/summary/atom.tpl');
        } elseif ($this->summary == 'rdf') {
            $this->objvew->setBaseFile('common/summary/rdf.tpl');
        } else {
            return ;
        }
        $this->objvew->setMimeType('text/xml');
        $modified = empty($this->_list[0]['modified'])? 'now':$this->_list[0]['modified'];

        /* プロフィール */
        $condition = array(
            'ref_account'=> $this->member['id']
        );
        $profile = RKT_DB::getRow('act_profile', $condition, 'nickname,comment');

        $summary = array(
            'title'=>       sprintf(_("%s's Blog"), $profile['nickname']),
            'link'=>        HTTP_ACTION.'member/blog/list/'.$this->member['id'].'/',
            'modified'=>    $modified,
            'creator'=>     $profile['nickname'],
            'description'=> strip_tags($profile['comment']),
            'list'=>        $this->_list
        );

        $this->objvew->assign('summary', $summary);
    }
} // class Controller
?>
