<?php
/* SVN FILE: $Id: comment.php 307 2008-05-09 22:53:36Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'blg_comment',
        ),
        'view'=> array(
        ),            
    );

    /**
     * blg_comment モデルオブジェクト
     * @var object 
     */
    public $blg_comment = null;

    /**
     * 記事(Member_Controllerで取得)
     * @var array
     */
    protected $entry = null;

    /**
     * コメントID
     * @var integer 
     */
    protected $ref_comment = null;

    /**
     * アクション
     * @var integer 
     */
    protected $action = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/blog.tpl');
        $this->blg_comment->setCurId($this->ref_comment);

        $this->blg_comment->setValue('ref_account', $this->member['id']);
        $this->blg_comment->setValue('ref_author',  $this->account['id'], RKT_Model::CONDITION);
        $this->blg_comment->setValue('ref_entry',   $this->id);
        $this->blg_comment->setValue('flag',        FLAG_UNREAD);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->account['status'] == STATUS_GUEST){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }
        $this->objvew->setRichEditor();
        $this->objvew->assign('entry', $this->entry);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_comment'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
