<?php
/* SVN FILE: $Id: member.php 520 2008-05-30 16:17:59Z bb_yujiro $ */
/**
 * 会員用Controllerクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 520 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:17:59 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 520 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:17:59 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Member_Controller extends RKT_Controller
{
    /**
     * 各種ID
     * @var integer
     */
    protected $id = null;

    /**
     * メンバー情報
     * @var array
     */
    protected $member = null;

    /**
     * 可視範囲
     * @var integer
     */
    protected $visible = null;

    /**
     * コントローラの読み込み
     *
     * @access public
     * @return object
     **/
    public function &getController($group, $module, $page)
    {
        $controller = array (
            'blog'=>        array(      // 日記
                'comment'=>     true,   // id is entry
                'comments'=>    true,
                'list'=>        true,
                'trackback'=>   true,   // id is entry
                'trackbacks'=>  true,
                'view'=>        true,   // id is entry
                'search'=>      true,
            ),
            'contact'=>     array(      // 各種投稿
                'comment'=>     true,
                'favorite'=>    true,
                'friendadd'=>   true,
            ),
            'personal'=>     array(     // 会員情報
                'album'=>       true,
                'calendar'=>    true,
                'community'=>   true,
                'friends'=>     true,
                'comment'=>     true,
                'photo'=>       true,
                'profile'=>     true,
                'search'=>      true,
            ),
            'poll'=>       array(       // アンケート
                'answer'=>      true,
                'list'=>        true,
                'search'=>      true,
                'view'=>        true,
            ),
            'schedule'=>    array(      // スケジュール
                'calendar'=>    true,
                'comment'=>     true,   // id is schedule
                'comments'=>    true,
                'list'=>        true,
                'view'=>        true,   // id is schedule
            ),
        );

        if (empty($controller[$module])){
            $module = 'personal';
            $page   = 'profile';
        }
        if (empty($controller[$module][$page])){
            $module = 'personal';
            $page   = 'profile';
        }

        $include = $group.DS.$module.DS.$page.'.php';
        include CONTROLLER_DIR.$include;

        $objController = new Controller($group.DS.$module.DS.$page.'.tpl');
        return $objController;
    }

    /**
     * グループ毎の初期化
     *
     * @access protected
     * @return void
     **/
    protected function initGrouping()
    {
        $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/member.tpl');
        $this->objvew->setTemplate('sidebar_tpl',  'common/menu/profile.tpl');
        $this->objvew->addCss('css/member.css');

        $this->account = RKT_account::exec()->getAccount();

        $this->_setMemberInfo();
        $this->_setVisible();

        $this->objvew->baseAssign('id', $this->id);
        $this->objvew->baseAssign('account', $this->account);
        $this->objvew->baseAssign('member',  $this->member);
        $this->objvew->baseAssign('visible', $this->visible);

        Theme::Id($this->member['ref_theme']);

        $visibility_icon = array(
            VISIBILITY_PUBLIC=>    ('world.gif'),
            VISIBILITY_PROTECTED=> ('user.gif'),
            VISIBILITY_PRIVATE=>   ('group_key.gif'),
        );
        $this->objvew->baseAssign('visibility_icon', $visibility_icon);

        /* アクセスログ */
        RKT_access::exec()->access(RKT_access::TARGET_MEMBER, 
                        $this->member['id'], $this->account['id']);
        
        $this->_accessBlock();
    }

    /**
     * メンバー情報の読み込み
     *
     * @access private
     * @return void
     **/
    private function _setMemberInfo()
    {
        /* パスインフォからIDを取得 */
        $condition = array(
            'type'=>     'number',
            'option'=>   array(),            
            'required'=> false,
            'pic_up'=>   'PathArgs'
        );
        if ($this->objrqt->catchValidate('id', $condition)){
            $this->id  = $this->objrqt->getRequest('id');
        }
        $tables = array (
            'blog'=>        array(      // 日記
                'view'=>        'blg_entry',
                'comment'=>     'blg_entry',
                'trackback'=>   'blg_entry',
            ),
            'poll'=>        array(      // アンケート
                'answer'=>      'sum_poll',
                'view'=>        'sum_poll',
            ),
            'schedule'=>    array(      // スケジュール
                'view'=>        'cal_schedule',
                'comment'=>     'cal_schedule',
            ),
        );
        $name = array (
            'blog'=>     'entry',
            'poll'=>     'poll',
            'schedule'=> 'schedule',
        );

        /* パスインフォからモジュール名を取得 */
        $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
        $args   = explode('/', $path_info);
        $module = $args[PATH_INFO_MODULE];
        $page   = $args[PATH_INFO_PAGE];

        if (empty($tables[$module][$page])){
            $ref_account = $this->id;
        } else {
            $name = $name[$module];
            $row  = RKT_DB::getRow($tables[$module][$page], $this->id);
            $this->$name = $row;
            $ref_account = $row['ref_account'];
        }
        if (empty($ref_account)){
            $this->member['ref_theme'] = DEFAULT_THEME;
        } else {
            $this->member = RKT_DB::getRow('act_account', $ref_account);
        }

        /* メンバー情報が無い場合 */
        if (empty($this->member['id'])){
            $this->member = $this->account;
        }
    }

    /**
     * 可視範囲の設定
     *
     * @access private
     * @return void
     **/
    private function _setVisible()
    {
        $this->visible  = VISIBILITY_PUBLIC;      // ネット上に公開

        /* 会員判定 */
        if ($this->account['status'] == STATUS_GUEST){
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/public.tpl');
            return ;
        }
        $this->visible |= VISIBILITY_PROTECTED;

        /* 本人判定 */
        if ($this->member['id'] == $this->account['id']){
            $this->visible |= VISIBILITY_HIDDEN;
            $this->visible |= VISIBILITY_FRIEND;
            $this->visible |= VISIBILITY_PRIVATE;

            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
            $this->objvew->addCss('css/private.css');
            return ;
        }

        /* 友達判定 */
        $condition = array(
            'ref_friend'=>  $this->member['id'],
            'ref_account'=> $this->account['id']
        );
        $row = RKT_DB::getRow('fri_friends', $condition);
        if (empty($row['status'])){
            return ;
        }
        if ($row['status'] != STATUS_FRIEND_CONNECT){
            return ;
        }
        $this->visible |= VISIBILITY_FRIEND;        
    }

    /**
     * アクセスブロック
     *
     * @access private
     * @return void
     **/
    private function _accessBlock()
    {
        if (empty($this->member['block'])){
            return ;
        }
        $blocks = explode("\r\n", $this->member['block']);
        
        /* ブロック判定 */
        /* アカウント停止・退会済み判定 */
        if (!in_array($this->account['id'], $blocks) &&
            $this->member['avail'] == STATUS_ENABLE){
            return ;
        }

        $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
        $this->objvew->setContentFile('common'.DS.'error'.DS.'access.tpl');
        $this->objvew->baseAssign('member',  $this->account);
        $this->objvew->addCss('css/private.css');
    }
} // class Controller
?>
