<?php
/* SVN FILE: $Id: search.php 523 2008-05-30 16:21:00Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 523 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:21:00 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 523 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-31 01:21:00 +0900 (土, 31 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'com_community',
        ),            
    );

    /**
     * com_community モデルオブジェクト
     * @var object 
     */
    public $v_com_community = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        if ($this->account['status'] == STATUS_GUEST){
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/public.tpl');
        } else {
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
        }
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/communitySearch.tpl');
        $this->objvew->setContentFile('community'.DS.'view'.DS.'search.tpl');
        $this->objvew->addCss('css/private.css');
        $this->objvew->baseAssign('member',  $this->account);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->assign('order_label', $this->v_com_community->getOrderLabel());
    }
} // class Controller
?>
