<?php
/* SVN FILE: $Id: names.php 232 2008-05-02 18:56:05Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 232 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-03 03:56:05 +0900 (土, 03 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_names',
        ),
        'view'=> array(
        ),            
    );

    /**
     * com_names モデルオブジェクト
     * @var object 
     */
    public $com_names = null;

    /**
     * 名簿ID
     * @var integer 
     */
    protected $ref_names = null;

    /**
     * ステータス
     * @var integer 
     */
    protected $status = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_names->setCurId($this->ref_names);

        $this->com_names->setValue('ref_community', $this->community['id']);
        $this->com_names->setValue('status',        $this->status);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->permission & PERMISSION_LEADER)){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        if (!empty($_POST['manip']) && $this->checked_nonce){
            $this->com_names->setValue('status', $this->status);
            $this->com_names->manip();
        }

        $img = '<img src="'.BASE_URL.'resource/img/icons/%s" width="16" height="16" align="absmiddle" />&nbsp;';
        $title = array(
            PERMISSION_MEMBER=>  sprintf($img, 'group_add.gif') . _('Add Member'),
            PERMISSION_REFUSAL=> sprintf($img, 'cross.gif') . _('Expulsion'),
            PERMISSION_CHANGE=>  sprintf($img, 'leader_change.gif') . _('Change Leader'),
        );
        $this->objvew->assign('title', $title[$this->status]);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_names'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }
} // class Controller
?>
