<?php
/* SVN FILE: $Id: invite.php 307 2008-05-09 22:53:36Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 307 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-10 07:53:36 +0900 (土, 10 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_message',
        ),
        'view'=> array(
        ),            
    );

    /**
     * fri_message モデルオブジェクト
     * @var object 
     */
    public $fri_message = null;

    /**
     * 紹介者リスト
     * @var array 
     */
    protected $friends = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->fri_message->setValue('status',      MESSAGE_SENT);
        $this->fri_message->setValue('ref_account', $this->account['id']);
        $this->fri_message->setValue('ref_to',      $this->account['id']);
        $this->fri_message->setValue('ref_from',    $this->account['id']);
        $this->fri_message->setValue('ref_message', 0);
        $this->fri_message->setValue('flag',        FLAG_READ);
        
        $this->fri_message->setToList($this->friends);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->account['status'] == STATUS_GUEST){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }
        $this->objvew->setRichEditor();

        $this->_setFriends();
        $this->_setInvite();

        $link  = '<a href="'.HTTP_ACTION.'community/view/community/';
        $link .= $this->community['id'].'/" />';
        $link .= '<img src="'.BASE_URL.'resource/img/icons/group.gif"';
        $link .= ' width="16" height="16" align="absmiddle"';
        $link .= ' title="'.$this->community['community'].'" />';
        $link .= $this->community['community'].'</a>';

        $this->objvew->assign('community_link', $link);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'friends'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 友達リストの設定
     *
     * @access protected
     * @return void
     **/
    private function _setFriends()
    {
        $condition = array(
            'ref_account'=> $this->account['id']
        );
        $list = RKT_DB::getList('fri_friends', $condition, 'ref_friend');
        $friends = array();
        foreach ($list as $row){
            $friends[$row['ref_friend']] = $row['ref_friend'];
        }

        $condition = array(
            'ref_community'=> $this->community['id']
        );
        $list = RKT_DB::getList('com_names', $condition, 'ref_account');
        foreach ($list as $row){
            if (!empty($friends[$row['ref_account']])){
                unset($friends[$row['ref_account']]);
            }
        }

        foreach ($friends as $ref_account){
            $profile = RKT_DB::getRow('act_profile', $ref_account, 'nickname');
            $label  = $profile['nickname'].'&nbsp;';
            $label .= '<a href="'.HTTP_ACTION.'member/personal/profile/';
            $label .= $ref_account.'/" />';
            $label .= '<img src="'.BASE_URL.'resource/img/icons/vcard.gif"';
            $label .= ' width="16" height="16" align="absmiddle"';
            $label .= ' title="'.$profile['nickname'].'" /></a>';

            $friends[$ref_account] = $label;
        }
        $this->objvew->assign('friends', $friends);
    }

    /**
     * 友達リストの設定
     *
     * @access protected
     * @return void
     **/
    private function _setInvite()
    {
        if (empty($_POST['manip']) || !$this->checked_nonce){
            return ;
        }
        if (!($this->permission & PERMISSION_LEADER)){
            return ;
        }
        if (!count($this->friends)){
            return ;
        }
        include MODEL_DIR.'manips'.DS.'com_names.php';
        $objnam = new com_names();

        $objnam->setValue('ref_community', $this->community['id']);
        $objnam->setValue('status',        PERMISSION_INVITE);
        $objnam->setValue('visibility',    VISIBILITY_HIDDEN);
        $objnam->setValue('bulletin',      STATUS_DISABLE);
        $objnam->setValue('comment',       '');

        foreach ($this->friends as $ref_account){
            $objnam->setValue('ref_account', $ref_account);
            $objnam->manip();
        }
    }
} // class Controller
?>
