<?php
/* SVN FILE: $Id: view.php 412 2008-05-18 07:46:01Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_attend'
        ),
        'view'=> array(
            'com_report'
        ),            
    );

    /**
     * com_attend モデルオブジェクト
     * @var object 
     */
    public $com_attend = null;

    /**
     * com_report モデルオブジェクト
     * @var object 
     */
    public $v_com_report = null;

    /**
     * イベント情報(Member_Controllerで取得)
     * @var array
     */
    protected $event = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/eventSearch.tpl');

        $this->com_attend->setValue('ref_event',     $this->id,              RKT_Model::CONDITION);
        $this->com_attend->setValue('ref_community', $this->community['id'], RKT_Model::CONDITION);
        $this->com_attend->setValue('ref_account',   $this->account['id'],   RKT_Model::CONDITION);

        $this->v_com_report->setValue('ref_community', $this->community['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->visible & $this->event['visibility'])){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();

        if ($this->checked_nonce && ($this->permission & PERMISSION_MEMBERS)){
            if (!empty($_POST['delete'])){
                $this->com_attend->setDelete();
            }
            $this->com_attend->manip();
        }
        $attend = $this->com_attend->getCurId();
        $this->objvew->assign('attend', $attend);
        $this->objvew->assign('event', $this->event);

        $this->objvew->assign('aheadDay',    strtotime('1 day'));
        $this->objvew->assign('aheadWeek',   strtotime('7 day'));
        $this->objvew->assign('aheadMonth',  strtotime('31 day'));
        $this->objvew->assign('aheadMonths', strtotime('3 months'));
        $this->objvew->assign('basing',      time());

        $this->objvew->assign('page', 'list/'.$this->community['id']);
    }
} // class Controller
?>
