<?php
/* SVN FILE: $Id: send.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_message',
        ),
        'view'=> array(
        ),            
    );

    /**
     * fri_message モデルオブジェクト
     * @var object 
     */
    public $fri_message = null;

    /**
     * イベント(Member_Controllerで取得)
     * @var array
     */
    protected $event = null;

    /**
     * 送信対象
     * @var array
     */
    protected $entries = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->fri_message->setValue('status',      MESSAGE_SENT);
        $this->fri_message->setValue('ref_account', $this->account['id']);
        $this->fri_message->setValue('ref_to',      $this->account['id']);
        $this->fri_message->setValue('ref_from',    $this->account['id']);
        $this->fri_message->setValue('ref_message', 0);
        $this->fri_message->setValue('flag',        FLAG_READ);
        
        $this->fri_message->setToList($this->entries);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->permission & PERMISSION_LEADER) && $this->event['ref_author'] != $this->account['id']){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();
        $this->objvew->assign('event', $this->event);

        $condition = array(
            'ref_event'=> $this->event['id']
        );
        $list = RKT_DB::getList('com_attend', $condition, 'ref_account');
        
        $entries = array();
        $checked = array();
        foreach ($list as $row){
            $profile = RKT_DB::getRow('act_profile', $row['ref_account'], 'nickname');
            $label  = $profile['nickname'].'&nbsp;';
            $label .= '<a href="'.HTTP_ACTION.'member/personal/profile/';
            $label .= $row['ref_account'].'/" />';
            $label .= '<img src="'.BASE_URL.'resource/img/icons/vcard.gif"';
            $label .= ' width="16" height="16" align="absmiddle"';
            $label .= ' title="'.$profile['nickname'].'" /></a>';

            $entries[$row['ref_account']] = $label;
            
            $checked[] = $row['ref_account'];
        }
        $this->objvew->assign('entries', $entries);
        $this->objvew->assign('checked', $checked);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'entries'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }
} // class Controller
?>
