<?php
/* SVN FILE: $Id: post.php 360 2008-05-12 00:21:04Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 360 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 09:21:04 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 360 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 09:21:04 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_event',
        ),
        'view'=> array(
        ),            
    );

    /**
     * com_event モデルオブジェクト
     * @var object 
     */
    public $com_event = null;

    /**
     * イベントID
     * @var integer 
     */
    protected $ref_event = null;

    /**
     * timestamp
     * @var integer
     */
    public $timestamp = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_event->setCurId($this->ref_event);

        $this->com_event->setValue('ref_community', $this->community['id']);
        $this->com_event->setValue('ref_author',    $this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if (!($this->permission & $this->community['event_flag'])){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();
        $this->objvew->addJavas('js/city.js');

        $this->_setTimeList();
        $this->_setCity();

        $img = '<img src="'.BASE_URL.'resource/img/icons/%s" width="16" height="16" align="absmiddle" />&nbsp;';
        $visibility = array(
            VISIBILITY_PUBLIC=>    sprintf($img, 'world.gif') . _('Public'),
            VISIBILITY_PROTECTED=> sprintf($img, 'user.gif') . _('Members'),
            VISIBILITY_PRIVATE=>   sprintf($img, 'group_key.gif') . _('Private'),
        );
        $this->objvew->assign('visibility', $visibility);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_event'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'timestamp'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    private function _setTimeList()
    {
        for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
            $hours[$num] = $num;
        }
        $sixty = array(
            '00'=>'00',
            '15'=>'15',
            '30'=>'30',
            '45'=>'45',
        );

        $this->objvew->assign('hours', $hours);
        $this->objvew->assign('sixty', $sixty);

        $this->timestamp = empty($this->timestamp)? time():$this->timestamp;
        $this->objvew->assign('date', date('Y-m-d', $this->timestamp));
    }

    /**
     * 市区町村の設定
     *
     * @abstract
     * @access protected
     * @return void
     */
    private function _setCity()
    {
        $ref_region = $this->com_event->getValue('ref_region');
        $condition = array(
            'ref_region'=> $ref_region
        );
        $list = $this->com_event->getReferenceList('ara_city', $order='sort', $condition);

        $this->objvew->assign('cities', $list);
    }
} // class Controller
?>
