<?php
/* SVN FILE: $Id: calendar.php 412 2008-05-18 07:46:01Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 412 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:46:01 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
        ),            
    );

    /**
     * タイムスタンプ
     * @var string
     */
    protected $timestamp = null;

    /**
     * 予定
     * @var array
     */
    private $_schedule = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/eventSearch.tpl');
        $this->timestamp = empty($this->timestamp)? strtotime(date('Y-m-01')):$this->timestamp;
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setAddSchedule();
        $this->_setSchedule();
        $this->objvew->assign('schedule', $this->_schedule);

        $this->objvew->assign('aheadDay',    strtotime('1 day'));
        $this->objvew->assign('aheadWeek',   strtotime('7 day'));
        $this->objvew->assign('aheadMonth',  strtotime('31 day'));
        $this->objvew->assign('aheadMonths', strtotime('3 months'));
        $this->objvew->assign('basing',      time());

        $this->objvew->assign('page', 'list/'.$this->community['id']);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'timestamp'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 編集リンクの作成
     *
     * @access public
     * @return void
     **/
    private function _setAddSchedule()
    {
        if (!($this->permission & $this->community['event_flag'])){
            return ;
        }

        $now   = strtotime(date('Y-m-01'));
        $start = 1;

        if ($this->timestamp < $now){
            return ;
        } elseif ($this->timestamp == $now){
            $start = date('d');
        }
                
        for ($day=$start; $day<=31; $day++){
            $days = strtotime(($day-1).' day', $this->timestamp);
            $anc  = '<a href="'.HTTP_ACTION.'community/event/post/'.
                    $this->community['id'].'/0/'.$days.'/'.'">'.
                    '<img src="'.BASE_URL.'resource/img/icons/date_edit.gif" '.
                    'width="16" height="16" align="absbottom" /></a>';
            $this->_schedule[$day][] = $anc;
        }
    }

    /**
     * スケジュールリストの設定
     *
     * @access private
     * @return void
     **/
    private function _setSchedule()
    {
        $start_date = date('Y-m-01', $this->timestamp);
        $last_date  = date('Y-m-t',  $this->timestamp);

        $n_start_time = strtotime($start_date);
        $n_last_time  = strtotime($last_date);

        $condition = array(
            'ref_community'=> $this->community['id'],
            'visibility'=>    array('&', $this->visible),
            'start_date1'=>   array('start_date', '>=', $start_date),
            'start_date2'=>   array('start_date', '<=', $last_date),
        );
        $list = RKT_DB::getList('com_event', $condition, 'id,event,start_date');

        $img = '<img src="'.BASE_URL.'resource/img/icons/event.gif" width="16" height="16" align="absmiddle" alt="" />';
        foreach ($list as $row){
            $start_time = strtotime($row['start_date']);
            $day        = date('j', $start_time);

            $href  = HTTP_ACTION.'community/event/view/'.$row['id'].'/';
            $label = mb_strimwidth($row['event'], 0, 20, '...');

            $anc  = '<br />';
            $anc .= '<a href="'.$href.'" title="'.$row['event'].'">';
            $anc .= $img.'</a>';
            $anc .= '<a href="'.$href.'" title="'.$row['event'].'">';
            $anc .= $label.'</a>';

            $this->_schedule[$day][] = $anc;
        }
    }
} // class Controller
?>
