<?php
/* SVN FILE: $Id: trackback.php 163 2008-04-23 00:35:07Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 163 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:35:07 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Community_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_trackback',
        ),
        'view'=> array(
        ),            
    );

    /**
     * com_trackback モデルオブジェクト
     * @var object 
     */
    public $com_trackback = null;

    /**
     * 記事(Member_Controllerで取得)
     * @var array
     */
    protected $article = null;

    /**
     * トラックバックID
     * @var integer 
     */
    protected $ref_trackback = null;

    /**
     * アクション
     * @var integer 
     */
    protected $action = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->com_trackback->setCurId($this->ref_trackback);

        $this->com_trackback->setValue('ref_community', $this->community['id'], RKT_Model::CONDITION);
        $this->com_trackback->setValue('ref_author',    $this->account['id']);
        $this->com_trackback->setValue('ref_article',   $this->id);
        $this->com_trackback->setValue('flag',          FLAG_UNREAD);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $delete = true;
        if (empty($this->action)){
            $this->objvew->setBaseFile('common/frame/xml.tpl');
            $delete = false;
        }
        $this->objvew->assign('error_code', 1);
        if ($this->visible & $this->article['visibility']){
            $this->_trackbackReceive();
        }
        $this->objvew->assign('article', $this->article);
        $this->objvew->assign('delete',  $delete);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_trackback'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * トラックバックの受信
     *
     * @access public
     * @return void
     **/
    private function _trackbackReceive()
    {
        include LIB_DIR.'PEAR/Services/Trackback.php';

        // トラックバック情報
        $trackbackData = array(
            'id'            => $this->article['id'],
            'host'          => $_SERVER['SERVER_ADDR'],
            'title'         => $this->article['article'],
            'excerpt'       => $this->article['comment'],
            'url'           => HTTP_ACTION.'community/article/view/'.$this->article['id'].'/',
            'blog_name'     => SNS_NAME,
            'trackback_url' => HTTP_ACTION.'community/article/trackback/'.$this->article['id'].'/'
        );
        // Services_Trackbackオブジェクトの作成
        $objtb = Services_Trackback::create($trackbackData);

        // 送信されたトラックバック情報を受信
        $result = $objtb->receive();
        if (PEAR::isError($result)) {
            return ;
        }

        $url        = $objtb->get('url');
        $hashed_url = RKT_Crypt::getHashed($url);
        $excerpt    = $objtb->get('excerpt');
        
        $this->com_trackback->title      = $objtb->get('title');
        $this->com_trackback->excerpt    = mb_strimwidth($excerpt, 0, 200, '...');
        $this->com_trackback->url        = $url;
        $this->com_trackback->hashed_url = $hashed_url;
        $this->com_trackback->blog_name  = $objtb->get('blog_name');
        $this->com_trackback->ip_address = $objtb->get('host');
        
        $this->com_trackback->manip();

        $this->objvew->assign('error_code', 0);
    }
} // class Controller
?>
