<?php
/* SVN FILE: $Id: type.php 317 2008-05-11 01:00:48Z bb_yujiro $ */
/**
 * 構築タイプの選択
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         hitSuji
 * @version         $Revision: 317 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:00:48 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
 
/**
 * Controllerクラス
 *
 * @category        hitSuji developer
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 317 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:00:48 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends RKT_Controller
{
    /**
     * ページタイプ
     * @var string
     */
    public $type = null;

    /**
     * テーブル名
     * @var string
     */
    public $table = null;

    /**
     * 作成パス
     * @var string
     */
    public $path = null;

    /**
     * アカウント情報
     * @var array
     */
    protected $account = array('status'=> STATUS_GUEST);

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setBaseFile('common/frame/xml.tpl');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_setTypes();
        $this->_setTables();

        if ($this->objrqt->getValidate() && !empty($_POST['manip'])){
            $pram  = '?page='.$this->type;
            $pram .= '&table='.urlencode($this->table);
            $pram .= '&path='.urlencode($this->path);
            header('Location: '.$_SERVER['PHP_SELF'].$pram);
        }

        if (!empty($_POST['manip'])){
            $this->objvew->assign('alert', $this->objrqt->getAlerts());
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'type'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true
            ),
            'table'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true
            ),
            'path'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false
            ),
        );
    }

    /**
     * タイプの設定
     *
     * @access private
     * @return string   絞込み句
     **/
    private function _setTypes()
    {
        $type = array (
            'manip'=> _('Manipulation'),
            'view'=>  _('List'),
        );
        $this->objvew->assign('types', $type);
    }

    /**
     * テーブルリストの設定
     *
     * @access private
     * @return string   絞込み句
     **/
    private function _setTables()
    {
        $objmdr = Model_Manip::factory();
        $result = $objmdr->getTables();

        $tables = array();
        foreach ($result as $table){
            $tables[$table] = $table;
        }

        $this->objvew->assign('tables', $tables);
    }
} // class Controller