<?php
/* SVN FILE: $Id: css.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rkt_blob.php';

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
        ),            
    );

    /**
     * テーマID
     * @var integer 
     */
    public $ref_theme = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/site.tpl');

        $theme = RKT_DB::getRow('des_theme', $this->ref_theme);
        $this->objvew->assign('theme', $theme);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $filename = ARCHIVES_THEME_PATH.$this->ref_theme.'/design.css';

        /* BLOB管理オブジェクトの生成 */
        $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM); 
        $objblb->load($filename);

        if ($this->checked_nonce){
            $buffer = empty($_POST['css'])? '':$_POST['css'];
            $objblb->setBuffer($buffer);
            $objblb->save($filename);
            $this->objvew->assign('updated', true);
        } else {
            $this->objvew->assign('css', $objblb->getBuffer());
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_theme'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
        );
    }
} // class Controller
?>
