<?php
/* SVN FILE: $Id: view.php 502 2008-05-25 12:52:15Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 502 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:52:15 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 502 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:52:15 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'cnt_contact',
        ),
        'view'=> array(
        ),            
    );

    /**
     * cnt_contact モデルオブジェクト
     * @var object 
     */
    public $cnt_contact = null;

    /**
     * 問合せID
     * @var integer 
     */
    protected $id = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/contact.tpl');

        $this->cnt_contact->setCurId($this->id);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_updateMessage();

        $this->objvew->assign('status',  $this->cnt_contact->status);

        $icons = array(
            RESPONSE_POST=> 'cap',
            RESPONSE_SEND=> 'unread',
            RESPONSE_SENT=> 'sent',
        );
        $this->objvew->assign('icons', $icons);

        $statuses = array(
            CONTACT_NEW=>       _('Inbox'),
            CONTACT_PENDING=>   _('Pending'),
            CONTACT_RESPONDED=> _('Responded'),
            CONTACT_TRASH=>     _('Trash'),
        );
        $this->objvew->assign('statuses', $statuses);

        $munu_class = array(
            CONTACT_NEW=>       '',
            CONTACT_PENDING=>   '',
            CONTACT_RESPONDED=> '',
            CONTACT_TRASH=>     '',
            'category'=>        '',
        );
        $munu_class[$this->cnt_contact->status] = ' class="column"';
        $this->objvew->assign('menu_class', $munu_class);

        $condition = array(
            'ref_contact'=> $this->id
        );
        $list = RKT_DB::getList('cnt_response', $condition, '*', 'modified');
        $this->objvew->assign('response', $list);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * メッセージの更新
     *
     * @access private
     * @return void
     **/
    private function _updateMessage()
    {
        $this->cnt_contact->setValue('flag', FLAG_READ);
        $this->cnt_contact->setUpdate();
        $this->cnt_contact->manip();
    }
} // class Controller
?>
