<?php
/* SVN FILE: $Id: respond.php 500 2008-05-25 12:50:51Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 500 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:50:51 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 500 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:50:51 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'cnt_response',
        ),
        'view'=> array(
        ),            
    );

    /**
     * cnt_response モデルオブジェクト
     * @var object 
     */
    public $cnt_response = null;

    /**
     * 問合せID
     * @var integer
     */
    public $ref_contact = null;

    /**
     * 対応ID
     * @var integer
     */
    public $id = null;

    /**
     * ステータス
     * @var integer
     */
    public $send = 0;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/contact.tpl');

        $this->cnt_response->setCurId($this->id);

        $this->cnt_response->setValue('send',        $this->send);
        $this->cnt_response->setValue('ref_contact', $this->ref_contact);
        $this->cnt_response->setValue('ref_account', $this->account['id']);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $contact  = RKT_DB::getRow('cnt_contact', $this->ref_contact);
        $this->objvew->assign('cnt_contact', $contact);

        $munu_class = array(
            CONTACT_NEW=>       '',
            CONTACT_PENDING=>   '',
            CONTACT_RESPONDED=> '',
            CONTACT_TRASH=>     '',
            'category'=>        '',
        );
        $munu_class[$contact['status']] = ' class="column"';
        $this->objvew->assign('menu_class', $munu_class);

        $cnt_category = $this->objmdl->getReferenceList('cnt_category');
        $this->objvew->assign('cnt_category', $cnt_category);


        $statuses = array(
            CONTACT_NEW=>       _('Inbox'),
            CONTACT_PENDING=>   _('Pending'),
            CONTACT_RESPONDED=> _('Responded'),
            CONTACT_TRASH=>     _('Trash'),
        );
        $this->objvew->assign('statuses', $statuses);
        $this->objvew->assign('status',   $contact['status']);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_contact'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'send'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false
            ),
        );
    }
} // class Controller
?>
