<?php
/* SVN FILE: $Id: mailbox.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'sys_message',
        ),
        'view'=> array(
            'sys_message',
        ),            
    );

    /**
     * sys_message モデルオブジェクト
     * @var object 
     */
    public $sys_message = null;

    /**
     * sys_message モデルオブジェクト
     * @var object 
     */
    public $v_sys_message = null;

    /**
     * ステータス
     * @var integer 
     */
    protected $status = 0;

    /**
     * ステータスの変更
     * @var integer 
     */
    protected $chenge = 0;

    /**
     * 対象メッセージ
     * @var array 
     */
    protected $messages = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/message.tpl');

        $this->status = empty($this->status)? MESSAGE_DRAFT:$this->status;
        $this->chenge = empty($this->chenge)? MESSAGE_TRASH:$this->chenge;

        $this->v_sys_message->setValue('status', $this->status);
        $this->v_sys_message->setOrder('regist_date DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->checked_nonce){
            $this->_updateMessage();
            $this->_deleteMessage();
        }

        $this->objvew->assign('status', $this->status);
        $statuses = array(
            MESSAGE_SENT=>  _('Sent'),
            MESSAGE_DRAFT=> _('Draft'),
            MESSAGE_TRASH=> _('Trash'),
        );
        $this->objvew->assign('statuses', $statuses);

        $icons = array(
            FLAG_UNREAD=> 'unread',
            FLAG_READ=>   'read',
            FLAG_RETURN=> 'return',
        );
        $this->objvew->assign('icons', $icons);

        $munu_class = array(
            MESSAGE_INBOX=> '',
            MESSAGE_SENT=>  '',
            MESSAGE_DRAFT=> '',
            MESSAGE_TRASH=> '',
        );
        $munu_class[$this->status] = ' class="column"';
        $this->objvew->assign('menu_class', $munu_class);

        $target = array(
            MESSAGE_SENT=>  'browse',
            MESSAGE_DRAFT=> 'send',
            MESSAGE_TRASH=> 'browse',
        );
        $this->objvew->assign('target', $target);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'chenge'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'messages'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * メッセージの更新
     *
     * @access private
     * @return void
     **/
    private function _updateMessage()
    {
        if (empty($_POST['manips'])){
            return ;
        }
        if (empty($this->messages)){
            return ;
        }

        foreach ($this->messages as $id){
            $this->sys_message->setCurId($id);
            $this->sys_message->setInitValue();

            $this->sys_message->setValue('status', $this->chenge);
            $this->sys_message->setUpdate();

            $this->sys_message->manip();
            $this->sys_message->refreshColumn();
        }
    }

    /**
     * メッセージの削除
     *
     * @access private
     * @return void
     **/
    private function _deleteMessage()
    {
        if (empty($_POST['delete'])){
            return ;
        }
        if (empty($this->messages)){
            return ;
        }

        foreach ($this->messages as $id){
            $this->sys_message->setCurId($id);
            $this->sys_message->setDelete();

            $this->sys_message->manip();
        }
    }
} // class Controller
?>
