<?php
/* SVN FILE: $Id: list.php 501 2008-05-25 12:51:23Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 501 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:51:23 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 501 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:51:23 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'cnt_contact',
        ),
        'view'=> array(
            'cnt_contact',
        ),            
    );

    /**
     * cnt_contact モデルオブジェクト
     * @var object 
     */
    public $cnt_contact = null;

    /**
     * cnt_contact モデルオブジェクト
     * @var object 
     */
    public $v_cnt_contact = null;

    /**
     * ステータス
     * @var integer 
     */
    public $status = 0;

    /**
     * ステータスの変更
     * @var integer 
     */
    public $chenge = 0;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/contact.tpl');

        $this->status = empty($this->status)? CONTACT_NEW  :$this->status;
        $this->chenge = empty($this->chenge)? CONTACT_TRASH:$this->chenge;

        $this->v_cnt_contact->setValue('status', $this->status);
        $this->v_cnt_contact->setOrder('regist_date DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_updateMessage();
        $this->_deleteMessage();

        $this->objvew->assign('status', $this->status);
        $statuses = array(
            CONTACT_NEW=>       _('Inbox'),
            CONTACT_PENDING=>   _('Pending'),
            CONTACT_RESPONDED=> _('Responded'),
            CONTACT_TRASH=>     _('Trash'),
        );
        $this->objvew->assign('statuses', $statuses);

        $icons = array(
            FLAG_UNREAD=> 'unread',
            FLAG_READ=>   'read',
            FLAG_RETURN=> 'return',
        );
        $this->objvew->assign('icons', $icons);

        $munu_class = array(
            CONTACT_NEW=>       '',
            CONTACT_PENDING=>   '',
            CONTACT_RESPONDED=> '',
            CONTACT_TRASH=>     '',
            'category'=>        '',
        );
        $munu_class[$this->status] = ' class="column"';
        $this->objvew->assign('menu_class', $munu_class);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'chenge'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'contacts'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * メッセージの更新
     *
     * @access private
     * @return void
     **/
    private function _updateMessage()
    {
        if (!$this->checked_nonce){
            return ;
        }
        if (empty($_POST['manips'])){
            return ;
        }
        if (empty($this->contacts)){
            return ;
        }

        foreach ($this->contacts as $id){
            $this->cnt_contact->setCurId($id);
            $this->cnt_contact->setInitValue();

            $this->cnt_contact->setValue('status', $this->chenge);
            $this->cnt_contact->setUpdate();
            $this->cnt_contact->manip();

            $this->cnt_contact->refreshColumn();
        }
    }

    /**
     * メッセージの削除
     *
     * @access private
     * @return void
     **/
    private function _deleteMessage()
    {
        if (!$this->checked_nonce){
            return ;
        }
        if (empty($_POST['delete'])){
            return ;
        }
        if (empty($this->contacts)){
            return ;
        }

        foreach ($this->contacts as $id){
            $this->cnt_contact->setCurId($id);
            $this->cnt_contact->setDelete();
            $this->cnt_contact->manip();
        }
    }
} // class Controller
?>
