<?php
/* SVN FILE: $Id: genre.php 514 2008-05-26 09:06:21Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 514 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-26 18:06:21 +0900 (月, 26 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 514 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-26 18:06:21 +0900 (月, 26 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_genre',
        ),
        'view'=> array(
        ),            
    );

    /**
     * com_genre モデルオブジェクト
     * @var object 
     */
    public $com_genre = null;

    /**
     * ジャンルID
     * @var integer 
     */
    protected $id = null;

    /**
     * 更新リスト
     * @var array
     */
    public $updates = null;

    /**
     * 削除リスト
     * @var array
     */
    public $deletes = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/communityGenre.tpl');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->checked_nonce){
            $this->_updategenres();
            $this->_deletegenres();
        }

        $munu_class = array(
            CONTACT_NEW=>       '',
            CONTACT_PENDING=>   '',
            CONTACT_RESPONDED=> '',
            CONTACT_TRASH=>     '',
            'category'=>        ' class="column"',
        );
        $this->objvew->assign('menu_class', $munu_class);

        $list = RKT_DB::getList('com_genre', null, '*', 'sort');
        $this->objvew->assign('genres', $list);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'updates'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'deletes'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 更新リストの処理
     *
     * @access private
     * @return void
     **/
    private function _updategenres()
    {
        if (empty($_POST['manips'])){
            return ;
        }
        if (empty($this->updates)){
            return ;
        }

        foreach ($this->updates as $id=>$row){
            $this->com_genre->setCurId($id);
            $this->com_genre->setInitValue();

            $this->com_genre->setValue('sort',  $row['sort']);
            $this->com_genre->setValue('genre', $row['genre']);
            $this->com_genre->manip();

            $this->com_genre->refreshColumn();
        }
    }

    /**
     * 削除リストの処理
     *
     * @access private
     * @return void
     **/
    private function _deletegenres()
    {
        if (empty($_POST['delete'])){
            return ;
        }
        if (empty($this->deletes)){
            return ;
        }

        foreach ($this->deletes as $id){
            $this->com_genre->setCurId($id);
            $this->com_genre->setDelete();
            $this->com_genre->manip();
        }
    }
} // class Controller
?>
