<?php
/* SVN FILE: $Id: community.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'com_community',
        ),
        'view'=> array(
            'viw_community',
        ),            
    );

    /**
     * com_community モデルオブジェクト
     * @var object 
     */
    public $com_community = null;

    /**
     * viw_community モデルオブジェクト
     * @var object 
     */
    public $v_viw_community = null;

    /**
     * コミュニティID
     * @var integer 
     */
    protected $id = null;

    /**
     * 有効・無効
     * @var integer 
     */
    protected $avail = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/communitySearch.tpl');
        $this->com_community->setCurId($this->id);

        if ($this->avail !== ''){
            $this->com_community->setValue('avail', $this->avail);
        }
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->_avail();
        $this->objvew->setRichEditor();
        $this->objvew->setViewEditor();

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_PRIVATE=>   _('Private'),
        );
        $this->objvew->assign('visibility', $visibility);

        $involved = array(
            PERMISSION_MEMBER=>  _('Anyone can be involved'),
            PERMISSION_REQUEST=> _('Who must approve Admin'),
        );
        $this->objvew->assign('involved', $involved);

        $permission = array(
            PERMISSION_MEMBERS=> _('All Members'),
            PERMISSION_LEADER=>   _('Only Admin'),
        );
        $this->objvew->assign('permission', $permission);

        $this->objvew->assign('order_label', $this->v_viw_community->getOrderLabel());
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'avail'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }

    /**
     * 有効/無効の設定
     *
     * @abstract
     * @access protected
     * @return void
     */
    private function _avail()
    {
        $list = array(
            STATUS_ENABLE=>  _('Enable'),
            STATUS_DISABLE=> _('Disable'),
        );

        $this->objvew->assign('avail', $list);
    }
} // class Controller
?>
