<?php
/* SVN FILE: $Id: analyze.php 499 2008-05-25 12:49:04Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 499 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:49:04 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 499 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 21:49:04 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 一週間
     * @var array
     */
    private $_weekly = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/communitySearch.tpl');
        $time = array(
            strtotime('-6 day'), 
            strtotime('-5 day'),
            strtotime('-4 day'),
            strtotime('-3 day'),
            strtotime('-2 day'),
            strtotime('-1 day'),
            time(),
        );
        
        $this->_weekly = array();
        $weekly = array();
        foreach ($time as $row){
            $date = date('d', $row);
            $this->_weekly[$date] = date('Y-m-d', $row);
            $weekly[] = $date;
        }
        $this->objvew->assign('weekly', $weekly);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->addJavas('yui/element/element-beta-min.js');
        $this->objvew->addJavas('yui/datasource/datasource-beta-min.js');
        $this->objvew->addJavas('yui/charts/charts-experimental-min.js');
        
        $this->_setNewCommunity();
        $this->_setNonMobileAccess();
        $this->_setMobileAccess();
        
        $this->_setCategory();
    }

    /**
     * 新規コミュニティの設定
     *
     * @access private
     * @return void
     **/
    private function _setNewCommunity()
    {
        $result = array();
        foreach ($this->_weekly as $day=>$date) {
            $condition = array(
                array('regist_date', '>=', $date.' 00:00:00'),
                array('regist_date', '<=', $date.' 23:59:59'),
            );
            $row = RKT_DB::getRow('com_community', $condition, 'count(*) as ct');
            
            $result[$day] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('newface', $result);
    }

    /**
     * モバイル以外のアクセス設定
     *
     * @access private
     * @return void
     **/
    private function _setNonMobileAccess()
    {
        $result = array();
        foreach ($this->_weekly as $day=>$date) {
            $condition = array(
                array('modified','>=', $date.' 00:00:00'),
                array('modified','<=', $date.' 23:59:59'),
                array('ismobile', '=', '0'),
                array('target',   '=', RKT_access::TARGET_COMMUNITY),
            );
            $row = RKT_DB::getRow('log_access', $condition, 'count(*) as ct');
            
            $result[$day] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('nonm', $result);
    }

    /**
     * モバイルのアクセス設定
     *
     * @access private
     * @return void
     **/
    private function _setMobileAccess()
    {
        $result = array();
        foreach ($this->_weekly as $day=>$date) {
            $condition = array(
                array('modified','>=', $date.' 00:00:00'),
                array('modified','<=', $date.' 23:59:59'),
                array('ismobile', '=', '1'),
                array('target',   '=', RKT_access::TARGET_COMMUNITY),
            );
            $row = RKT_DB::getRow('log_access', $condition, 'count(*) as ct');
            
            $result[$day] = empty($row['ct'])? 0:$row['ct'];
        }
        $this->objvew->assign('mobile', $result);
    }

    /**
     * カテゴリ別の設定
     *
     * @access private
     * @return void
     **/
    private function _setCategory()
    {
        $genres = RKT_DB::getList('com_genre');
        
        $id2genre = array();
        foreach ($genres as $genre){
            $id2genre[$genre['id']] = $genre['genre'];
        } // foreach ($genres as $genre)

        $categories = RKT_DB::getList('com_category');
        $list = array();
        foreach ($categories as $category){
            $condition = array(
                'ref_category'=> $category['id'],
            );
            $row = RKT_DB::getRow('com_community', $condition, 'count(*) as ct');
            if (!empty($row['ct'])){
                if (empty($list[$category['ref_genre']])){
                    $list[$category['ref_genre']] = 0;
                }
                $list[$category['ref_genre']] += $row['ct'];
            }
        } // foreach ($categories as $category)

        $result = array();
        foreach ($list as $id=> $row){
            $result[] = array(
                'genre'=>  $id2genre[$id],
                'number'=> $row,
            );
        }

        $this->objvew->assign('category', $result);
    }

} // class Controller
?>
