<?php
/* SVN FILE: $Id: list.php 385 2008-05-15 02:43:17Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'viw_account',
        ),            
    );

    /**
     * viw_account モデルオブジェクト
     * @var object 
     */
    public $v_viw_account = null;

    /**
     * アカウントID
     * @var integer 
     */
    protected $ref_account = null;

    /**
     * Agentアクション
     * @var string
     */
    protected $agent = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/accountSearch.tpl');
        $this->v_viw_account->setOrder('act.regist_date DESC');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->addJavas('js/city.js');

        $this->_agent();

        $this->_setList();
        $this->_setAvail();
        $this->_setMailing();        
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_account'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
            'agent'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
                'pic_up'=>   'PathArgs'
            ),
        );
    }

    /**
     * 他のユーザーとしてログイン
     *
     * @abstract
     * @access protected
     * @return boolean
     */
    private function _agent()
    {
        if ($this->agent !== 'agent'){
            return ;
        }
        $account = RKT_DB::getRow('act_account', $this->ref_account);
        if (empty($account)){
            return ;
        }
        $account['status'] = STATUS_ADMIN;

        $_SESSION[RKT_account::ACCOUNT_KEY] = $account;
        header('Location: '.HTTP_ACTION.'private/');
        exit();
    }

    /**
     * 一覧の設定
     *
     * @abstract
     * @access protected
     * @return void
     */
    private function _setList()
    {
        $result = $this->v_viw_account->getValues();
        $list   = array();
        foreach ($result as $row){
            /* プロフィール */
            $condition = array(
                'ref_friend'=> $row['id']
            );
            $invite = RKT_DB::getRow('fri_invite', $condition, 'ref_account');

            $row['ref_account'] = empty($invite['ref_account'])? 0:$invite['ref_account'];
            $list[] = $row;
        }

        $this->objvew->assign('list', $list);
    }

    /**
     * 有効/無効の設定
     *
     * @abstract
     * @access protected
     * @return void
     */
    private function _setAvail()
    {
        $list = array(
            STATUS_ENABLE=>  _('Enable'),
            STATUS_DISABLE=> _('Disable'),
            ''=> _('No Select'),
        );

        $this->objvew->assign('avail', $list);
    }

    /**
     * メーリングの設定
     *
     * @abstract
     * @access protected
     * @return void
     */
    private function _setMailing()
    {
        $list = array(
            STATUS_ENABLE=>  _('Receive'),
            STATUS_DISABLE=> _('Not receive'),
            ''=> _('No Select'),
        );

        $this->objvew->assign('mailing', $list);
    }
} // class Controller
?>
