<?php
/* SVN FILE: $Id: item.php 293 2008-05-09 00:08:33Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 293 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:33 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'act_item',
        ),
        'view'=> array(
        ),            
    );

    /**
     * act_item モデルオブジェクト
     * @var object 
     */
    public $act_item = null;

    /**
     * 項目ID
     * @var integer
     */
    protected $ref_item = null;

    /**
     * 解答用入力欄
     * @var array
     */
    protected $answers = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/profile.tpl');

        $this->act_item->setCurId($this->ref_item);

        $this->act_item->setValue('answers', $this->answers);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->addJavas('js/answer.js');
        $list = RKT_DB::getList('act_item', null, '*', 'sort');
        $this->objvew->assign('items', $list);
        
        $this->_setAnswer();

        $required = array(
            STATUS_DISABLE=> _('Any Value'),
            STATUS_ENABLE=>  _('Required'),
        );
        $this->objvew->assign('required', $required);

        $visible = array(
            VISIBLE_DISPLAY=> _('Display'),
            VISIBLE_SELECT=>  _('User Select'),
        );
        $this->objvew->assign('visible', $visible);

        $type = array(
            FORM_TYPE_TEXT=>     _('Text Form'),
            FORM_TYPE_TEXTAREA=> _('Text Area'),
            FORM_TYPE_SELECT=>   _('Select Form'),
            FORM_TYPE_CHECKBOX=> _('Check Box'),
            FORM_TYPE_RADIO=>    _('Radio Button'),
            FORM_TYPE_DATE=>     _('Date Form'),
        );
        $this->objvew->assign('type', $type);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'ref_item'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'answers'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 解答用入力欄設定
     *
     * @abstract
     * @access private
     * @return void
     */
    private function _setAnswer()
    {
        $arrays = $this->act_item->answers;
        $arrays = is_array($arrays)? $arrays:array();
        $this->objvew->assign('answers', $arrays);
    }
} // class Controller
?>
