<?php
/* SVN FILE: $Id: admin.php 353 2008-05-11 22:57:53Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 353 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-12 07:57:53 +0900 (月, 12 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Admin_Controller extends RKT_Controller
{
    /**
     * コントローラの読み込み
     *
     * @access public
     * @return object
     **/
    public function &getController($group, $module, $page)
    {
        $controller = array (
            'account'=>     array(      // アカウント
                'account'=>     true,
                'analyze'=>     true,
                'cancel'=>      true,
                'cancels'=>     true,
                'item'=>        true,
                'items'=>       true,
                'list'=>        true,
            ),
            'community'=>   array(      // コミュニティ
                'analyze'=>     true,
                'category'=>    true,
                'community'=>   true,
                'genre'=>       true,
                'list'=>        true,
            ),
            'contact'=>     array(      // お問合せ・メッセージ
                'category'=>    true,
                'list'=>        true,
                'mailbox'=>     true,
                'message'=>     true,
                'respond'=>     true,
                'send'=>        true,
                'template'=>    true,
                'templates'=>   true,
                'view'=>        true,
            ),
            'contents'=>    array(      // コンテンツ記事
                'article'=>     true,
                'list'=>        true,
                'trackbacks'=>  true,
            ),
            'design'=>      array(      // デザイン設定
                'css'=>         true,
                'list'=>        true,
                'makeup'=>      true,
                'preview'=>     true,
                'theme'=>       true,
                'upload'=>      true,
            ),
            'master'=>      array(      // マスターテーブル
                'married'=>     true,
                'review'=>      true,
                'taste'=>       true,
             ),
            'setting'=>     array(      // 環境設定
                'config'=>      true,
            ),
            'sponsor'=>     array(      // スポンサー
                'list'=>        true,
                'sponsor'=>     true,
            ),
        );

        if (empty($controller[$module])){
            $module = 'account';
            $page   = 'analyze';
        }
        if (empty($controller[$module][$page])){
            $module = 'account';
            $page   = 'analyze';
        }

        $status  = RKT_account::exec()->getStatus();
        if ($status != STATUS_ADMIN){
            include CONTROLLER_DIR.'public.php';
            $group  = 'public';
            $module = 'login';
            $page   = 'entrance';
        }

        $include = $group.DS.$module.DS.$page.'.php';
        include CONTROLLER_DIR.$include;
        
        $objController = new Controller($group.DS.$module.DS.$page.'.tpl');
        return $objController;
    }

    /**
     * グループ毎の初期化
     *
     * @access protected
     * @return void
     **/
    protected function initGrouping()
    {
        $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/admin.tpl');
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/accountSearch.tpl');
        $this->objvew->addCss('css/admin.css');

        $this->account = RKT_account::exec()->getAccount();

        $this->objvew->baseAssign('account', $this->account);
        $this->objvew->baseAssign('member', $this->account);

        Theme::Id($this->account['ref_theme']);

        $visibility_icon = array(
            VISIBILITY_PUBLIC=>    ('world.gif'),
            VISIBILITY_PROTECTED=> ('user.gif'),
            VISIBILITY_PRIVATE=>   ('group_key.gif'),
        );
        $this->objvew->baseAssign('visibility_icon', $visibility_icon);
    }
} // class Controller
?>
