<?php
/* SVN FILE: $Id: rkt_view.php 455 2008-05-22 09:24:36Z bb_yujiro $ */
/**
 * Viewクラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        hitSuji Core
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 455 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:24:36 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktView/HTML.php';
require LIB_DIR.'rktView/Theme.php';

/**
 * Viewクラス
 *
 * @category        hitSuji Core
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 455 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:24:36 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_View
{
    /**
     * 基礎テンプレートファイル
     * @var string
     */
    public $template_base = 'common/frame/base.tpl';

    /**
     * テンプレートファイル
     * @var string
     */
    public $template_file = '';

    /**
     * 出力用
     * @var string
     */
    public $mimeType = 'text/html';

    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * 出力用エンコーディング
     * @var string
     */
    private $_outputEncoding = ENCODE_TYPE;

    /**
     * 基礎用変数
     * @var array
     */
    private $_base = array();

    /**
     * テンプレート
     * @var string
     */
    private $_template = '';

    /**
     * 解析結果
     * @var string
     */
    private $_parsed = '';

    /**
     * 置換変数
     * @var array
     */
    private $_vars = array();

    /**
     * CSS読み込み用
     * @var array
     */
    private $_css = array();

    /**
     * JavaScript読み込み用
     * @var array
     */
    private $_js = array();

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
        $agent = Net_UserAgent_Mobile::singleton();
        $name  = $agent->getCarrierLongName();
        
        $name2encode = array(
            'NonMobile'=> ENCODE_TYPE,
            'DoCoMo'=>    'SJIS',
            'EZweb'=>     'SJIS',
            'SoftBank'=>  ENCODE_TYPE,
            'WILLCOM'=>   ENCODE_TYPE,
        );
        $this->_outputEncoding = $name2encode[$name];

        $name2base = array(
            'NonMobile'=> 'common'.DS.'frame'.DS.'base.tpl',
            'DoCoMo'=>    'mobile'.DS.'common'.DS.'frame'.DS.'base.tpl',
            'EZweb'=>     'mobile'.DS.'common'.DS.'frame'.DS.'base.tpl',
            'SoftBank'=>  'mobile'.DS.'common'.DS.'frame'.DS.'base.tpl',
            'WILLCOM'=>   'mobile'.DS.'common'.DS.'frame'.DS.'base.tpl',
        );
        $this->template_base = $name2base[$name];

        $this->_base['content_tpl']    = VIEW_DIR.'common/error/error.tpl';
        $this->_base['sidebar_tpl']    = VIEW_DIR.'common/menu/private.tpl';
        $this->_base['generalbar_tpl'] = VIEW_DIR.'common/menuBar/general.tpl';
        $this->_base['groupbar_tpl']   = VIEW_DIR.'common/menuBar/public.tpl';
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @return object
     */
    public static function getInstance()
    {
        if (!isset(self::$_instance)) {
            $classname = __CLASS__;
            self::$_instance = new $classname();
        }
        return self::$_instance;
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function assign($key, $value)
    {
        $this->_vars[$key] = $value;
    }

    /**
     * スタイルシート外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    public function addCss($file)
    {
        $this->_css[$file] = $file;
    }

    /**
     * JavaScript外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    public function addJavas($file)
    {
        $this->_js[$file] = $file;
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function baseAssign($key, $value)
    {
        $this->_base[$key] = $value;
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function display()
    {
        $this->assign('base', $this->_base);

        ob_start();
        include VIEW_DIR.$this->template_base;
        $body = ob_get_contents();
        ob_end_clean();

        header('Content-Type: '.$this->mimeType.'; charset='.$this->_outputEncoding);

        /* クッキーが無効な場合 */
        if (SID !== ''){
            $body = HTML::transSessionID($body);
        }

        /* プラグインによる処理 */
        echo loadPlugin::exec()->outputFilter($body, $this->mimeType);
    }

    /**
     * HTML BODY出力用エフェクト
     *
     * @access public
     * @return string
     */
    public function getOutputEncoding()
    {
        return $this->_outputEncoding;
    }

    /**
     * テンプレートファイルの設定
     *
     * @access public
     * @param string $tpl_file
     * @return void
     */
    public function setBaseFile($tpl_file)
    {
        $this->template_base = $tpl_file;
    }

    /**
     * コンテンツ用テンプレートファイルの設定
     *
     * @access public
     * @param string $tpl_file
     * @return void
     */
    public function setContentFile($tpl_file)
    {
        $agent = Net_UserAgent_Mobile::singleton();
        $name  = $agent->getCarrierLongName();

        $name2type = array(
            'NonMobile'=> 'NonMobile',
            'DoCoMo'=>    'Mobile',
            'EZweb'=>     'Mobile',
            'SoftBank'=>  'Mobile',
            'WILLCOM'=>   'Mobile',
        );
        $type = $name2type[$name];

        $tplGroup = array(
            'NonMobile'=> '',
            'Mobile'=>    'mobile'.DS
        );
        $file = $tplGroup[$type].$tpl_file;

        $this->_base['content_tpl'] = VIEW_DIR.$file;
    }

    /**
     * MimeTypeの設定
     *
     * @access public
     * @param string $mime_type
     * @return void
     */
    public function setMimeType($mime_type)
    {
        $this->mimeType = $mime_type;
    }

    /**
     * テンプレートファイルの設定
     *
     * @access public
     * @param string $key
     * @param string $tpl_file
     * @return void
     */
    public function setTemplate($key, $tpl_file)
    {
        $this->_base[$key] = VIEW_DIR.$tpl_file;
    }

    /**
     * リッチエディタ用設定
     *
     * @access public
     * @param string $name
     * @return void
     */
    public function setRichEditor()
    {
        $this->addCss('yui/editor/assets/skin.css');
        $this->addCss('yui/editor/assets/editor.css');
        $this->addCss('css/richEditor.php');
        $this->addJavas('yui/element/element-beta-min.js');
        $this->addJavas('yui/button/button-min.js');
        $this->addJavas('yui/editor/editor-beta-min.js');
        $this->addJavas('js/richEditor.php');
    }

    /**
     * リッチエディタ用設定
     *
     * @access public
     * @param string $name
     * @return void
     */
    public function setViewEditor()
    {
        loadPlugin::exec()->outputEditorLoadJs();
    }
} // RKT_View
?>
