<?php
/* SVN FILE: $Id: rkt_session.php 280 2008-05-07 22:22:56Z bb_yujiro $ */
/**
 * セッション管理クラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        hitSuji Core
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 280 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:22:56 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * セッション管理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_session
 * @access public
 * @version 1.0
 */
class RKT_session
{
    /**
     * セッションネーム
     * @const string
     */
    const SESSION_KEY = 'sid';

    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * データベース接続オブジェクト
     * @access private
     * @var object
     */
    private $_objdb = null;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
        $this->_objdb = RKT_DB::getInstance();
        // ini_set('session.hash_function', '1');
        session_name(self::SESSION_KEY);
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @return object
     */
    public static function getInstance()
    {
        if (!isset(self::$_instance)) {
            $classname = __CLASS__;
            self::$_instance = new $classname();
        }
        return self::$_instance;
    }

    /**
     * 各ハンドルの設定
     *
     * @access public
     * @return void
     */
    public function setSaveHandler()
    {
        $objses = self::getInstance();

        session_set_save_handler(array(&$objses, 'open'),
                                 array(&$objses, 'close'),
                                 array(&$objses, 'read'),
                                 array(&$objses, 'write'),
                                 array(&$objses, 'destroy'),
                                 array(&$objses, 'gc'));
        register_shutdown_function('session_write_close');
        session_start();
    }

    /**
     * オープン
     *
     * @access public
     * @param string $save_path
     * @param string $session_name
     * @return boolean
     */
    public function open($save_path, $session_name)
    {
        return true;
    }

    /**
     * クローズ
     *
     * @access public
     * @return boolean
     */
    public function close()
    {
        /*
         * 強制的に100%
         * ini_set('session.gc_divisor', 100);
         * $this->gc(ini_get('session.gc_maxlifetime'));
         */
        return true;
    }

    /**
     * 読み込み
     *
     * @access public
     * @param string $id
     * @return string
     */
    public function read($id)
    {
        $sql = 'SELECT sess_data FROM '.RKT_TBL_SESSION.' WHERE id = :id';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(array(':id'=> $id));
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();

        return $result['sess_data'];
    }

    /**
     * 書き込み
     *
     * @access public
     * @param string $id
     * @param string $sess_data
     * @return boolean
     */
    public function write($id, $sess_data)
    {
        $sql = 'SELECT id FROM '.RKT_TBL_SESSION.' WHERE id = :id';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(array(':id'=> $id));
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $sql = 'INSERT INTO '.RKT_TBL_SESSION.' '.
                   '(id,life_time,sess_data) VALUES (:id,:life_time,:sess_data)';
        } else {
            $sql = 'UPDATE '.RKT_TBL_SESSION.
                   ' SET life_time = :life_time,sess_data = :sess_data'.
                   ' WHERE id = :id';
        }
        $stmt = $this->_objdb->prepare($sql);

        $life_time = time();

        $stmt->bindParam(':id',        $id,        PDO::PARAM_STR);
        $stmt->bindParam(':life_time', $life_time, PDO::PARAM_INT);
        $stmt->bindParam(':sess_data', $sess_data, PDO::PARAM_STR);

        return $stmt->execute();
    }

    /**
     * 廃棄
     *
     * @access public
     * @param string $id
     * @return void
     */
    public function destroy($id)
    {
        $sql = 'DELETE FROM '.RKT_TBL_SESSION.' WHERE id = :id';
        $stmt = $this->_objdb->prepare($sql);
        return $stmt->execute(array('id'=> $id));
    }

    /**
     * ガーベッジコレクション
     *
     * @access public
     * @param integer $maxlifetime
     * @return void
     *
     * コールされる確立(デフォルト100%)を以下で設定
     * ini_set('session.gc_divisor', 100);
     */
    public function gc($maxlifetime)
    {
        $deadline = time() - intval($maxlifetime);
        $sql = 'DELETE FROM '.RKT_TBL_SESSION.' WHERE life_time < :life_time';
        $stmt = $this->_objdb->prepare($sql);
        return $stmt->execute(array('life_time'=> $deadline));
    }
} // RKT_sessionの終了
?>