<?php
/**
 *  画像処理
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 182 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-27 02:18:59 +0900 (日, 27 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 *  画像処理クラス
 *
 * @category        Image
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 182 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-27 02:18:59 +0900 (日, 27 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_Image
{
    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * コンストラクタ
     *
     * @access private
     * @return void
     */
    private function __construct()
    {
    }

    /**
     * Singleton メソッド
     *
     * @access public
     * @param string $driver
     * @return object __CLASS__
     */
    public static function getInstance($driver=IMAGE_DRIVER)
    {
        if (!isset(self::$_instance)) {
            self::$_instance = self::factory($driver);
        }

        return self::$_instance;
    }

    /**
     * Factory メソッド
     *
     * @access public
     * @param string $driver
     * @return void
     */
    public static function factory($driver)
    {
        if (include LIB_DIR.'rktImage/'.$driver.'.php') {
            $classname = 'Image_'.$driver;
            return new $classname();
        } else {
            throw new Exception ('Driver not found');
        }
    }
} // RKT_Image
?>