<?php
/* SVN FILE: $Id: rkt_auth.php 280 2008-05-07 22:22:56Z bb_yujiro $ */
/**
 * ユーザー認証
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 280 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:22:56 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktAuth/AutoLogin.php';

/**
 * ユーザー認証クラス
 *
 * @category        Authentication
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 280 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:22:56 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class RKT_Auth
{
    /**
     * Singleton用インスタンス
     * @var object
     */
    private static $_instance;

    /**
     * ハッシュ化されたメール
     * @var string
     */
    private $_hashed_email = '';

    /**
     * ハッシュ化されたパスワード
     * @var string
     */
    private $_hashed_password = '';

    /**
     * アカウントID
     * @var integer
     */
    private $_account_id = null;

    /**
     * DBオブジェクト
     * @var object
     */
    private $_objdb = null;

    /**
     * コンストラクタ
     *
     * @access private
     */
    private function __construct()
    {
        $this->_objdb      = RKT_DB::getInstance();
        $this->_account_id = RKT_account::exec()->getAccountID();
    }

    /**
     * 実行処理スタテック版
     *
     * @access public
     * @return object
     *
     * RKT_account::exec()->getAccount();
     *
     */
    public static function exec()
    {
        if (!isset(self::$_instance)) {
            $classname = __CLASS__;
            self::$_instance = new $classname();
        }
        return self::$_instance;
    }

    /**
     * パスワード用ハッシュ
     *
     * @access private
     * @param string $string
     * @return string
     */
    public static function getHashed($string)
    {
        $seed = RKT_Crypt::getHashed($string);
        $seed = PASS_SEED.$seed.PASS_SEED;
        $hashed = RKT_Crypt::getHashed($seed);
        return $hashed;
    }

    /**
     * ワンタイムパスワードの設定
     *
     * @access public
     * @return string セッションID
     */
    public static function setNonce()
    {
        $now   = time();
        $just  = ceil($now / NONCE_LIFE_TIME);
        $next  = NONCE_LIFE_TIME * $just;
        $extra = $next - $now;

        $_SESSION['extraTime'] = $extra;
        
        $nonce = RKT_Crypt::getNonce('sessionNonce');
        
        $_SESSION['sessionNonce'] = $nonce;
    }

    /**
     * ログイン
     *
     * @access public
     */
    public function logIn()
    {
        $this->_setRequest();
        $sql = 'SELECT id,hashed_password FROM '.DB_PREFIX.'act_account '.
               'WHERE hashed_email = :hashed_email';
        $stmt = $this->_objdb->prepare($sql); 
        $stmt->execute(array(':hashed_email'=> $this->_hashed_email));
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stmt->closeCursor();

        /* 取得結果の判定 */
        if (empty($result)){
            RKT_account::exec()->accountDestroy();
            return false;
        }

        /* パスワードの整合性 */
        if ($result['hashed_password'] !== $this->_hashed_password){
            RKT_account::exec()->accountDestroy();
            return false;
        }

        /* アカウント情報を取得できたか */
        if (!RKT_account::exec()->setAccount($result['id'])){
            RKT_account::exec()->accountDestroy();
            return false;
        }
        $this->setNonce();

        return true;
    }

    /**
     * ログアウト
     *
     * @access public
     */
    public function logOut()
    {
        $sql = 'DELETE FROM '.DB_PREFIX.'act_autologin '.
               'WHERE ref_account = :ref_account';
        $stmt = $this->_objdb->prepare($sql);
        $stmt->execute(array(':ref_account'=> $this->_account_id));

        unset($_COOKIE['loginkey']);
        setcookie('loginkey', '', time()-3600, '/');

        RKT_account::exec()->accountDestroy();

        session_regenerate_id(true);
    }

    /**
     * ユーザーリクエストを取得しメンバーへ設定
     *
     * @access private
     * @return array ユーザーリクエスト
     */
    private function _setRequest()
    {
        $email = '';

        // ログイン名
        if (!empty($_POST['email'])){
            $email = $_POST['email'];
        }
        // Eメール整合性チェック
        if (!Validate::email($email)){
            $email = '';
        }
        $this->_hashed_email = RKT_Crypt::getHashed($email);

        // パスワード
        if (!empty($_POST['password'])){
            $this->_hashed_password = RKT_auth::getHashed($_POST['password']);
        }
    }
} // RKT_authの終了
?>
